/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsIgnore;

import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfoImpl;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public class UserDirIgnores {
    private List<SimpleStringPattern> myPatterns;
    @NonNls
    private static final File ourUserHomeCVSIgnoreFile;

    public List<SimpleStringPattern> getPatterns() {
        if (this.myPatterns == null) {
            this.myPatterns = UserDirIgnores.createUserDirIgnoredFilesInfo();
        }
        return this.myPatterns;
    }

    private static List<SimpleStringPattern> createUserDirIgnoredFilesInfo() {
        File file = UserDirIgnores.userHomeCvsIgnoreFile();
        ApplicationManager.getApplication().invokeLater(() -> CvsVfsUtil.refreshAndFindFileByIoFile(file), ModalityState.NON_MODAL);
        return IgnoredFilesInfoImpl.getPattensFor(file);
    }

    public static File userHomeCvsIgnoreFile() {
        return ourUserHomeCVSIgnoreFile;
    }

    public void clearInfo() {
        this.myPatterns = null;
    }

    static {
        File homeDir;
        String home = System.getenv().get("HOME");
        ourUserHomeCVSIgnoreFile = home != null ? ((homeDir = new File(home)).exists() && homeDir.isDirectory() ? new File(homeDir, ".cvsignore") : new File(SystemProperties.getUserHome() + "/" + ".cvsignore")) : new File(SystemProperties.getUserHome() + "/" + ".cvsignore");
    }
}

