/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ws.http.request.lexer._HttpRequestFileLexer;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpRequestStubElements;
import com.intellij.ws.http.request.psi.HttpRequestTokenTypeSets;

public class HttpRequestFileLexer
extends MergingLexerAdapterBase {
    private final MergeFunction myMergeFunction = new HttpMergeFunction();

    public HttpRequestFileLexer() {
        super((Lexer)new FlexAdapter((FlexLexer)new _HttpRequestFileLexer()));
    }

    public MergeFunction getMergeFunction() {
        return this.myMergeFunction;
    }

    private static class HttpMergeFunction
    implements MergeFunction {
        private static final TokenSet TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.MESSAGE_TEXT, HttpRequestStubElements.EMBEDDED_CONTENT, HttpRequestElementTypes.SEGMENT, HttpRequestElementTypes.QUERY_NAME, HttpRequestElementTypes.QUERY_VALUE, HttpRequestTokenTypeSets.LINE_COMMENT});

        private HttpMergeFunction() {
        }

        public IElementType merge(IElementType type, Lexer originalLexer) {
            IElementType tokenType;
            if (type == HttpRequestElementTypes.INTERMEDIATE_WHITESPACE) {
                return TokenType.WHITE_SPACE;
            }
            if (!TO_MERGE.contains(type)) {
                return type;
            }
            while (type == (tokenType = originalLexer.getTokenType()) || HttpMergeFunction.continueMerge(type, tokenType)) {
                LexerPosition position = originalLexer.getCurrentPosition();
                while (HttpMergeFunction.continueMerge(type, tokenType)) {
                    originalLexer.advance();
                    tokenType = originalLexer.getTokenType();
                }
                if (tokenType != type) {
                    originalLexer.restore(position);
                    break;
                }
                originalLexer.advance();
            }
            return type;
        }

        private static boolean continueMerge(IElementType original, IElementType next) {
            if (next == TokenType.WHITE_SPACE) {
                return original == HttpRequestElementTypes.MESSAGE_TEXT || original == HttpRequestTokenTypeSets.LINE_COMMENT;
            }
            return next == HttpRequestElementTypes.INTERMEDIATE_WHITESPACE;
        }
    }
}

