/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaExportHelper {
    private static final Key<Boolean> FK_PULLED_MARK = Key.create((String)"SchemaExportHelper.FK_PULLED_MARK");
    private final Map<DasObject, DeObject> myCache;
    private final DatabaseEditorContext myContext;
    private final SchemaExporters myExporter;
    private final DeModel myModel;
    private final DeObject.DeCopier myCopier;
    private final Set<DasObject> myLocked;

    @NotNull
    public DeObject.DeCopier getCopier() {
        DeObject.DeCopier deCopier = this.myCopier;
        if (deCopier == null) {
            SchemaExportHelper.$$$reportNull$$$0(0);
        }
        return deCopier;
    }

    public SchemaExportHelper(@NotNull SchemaExportHelper other) {
        if (other == null) {
            SchemaExportHelper.$$$reportNull$$$0(1);
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myCopier = new DeObject.DeCopier(){

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                return SchemaExportHelper.this.export(object, child);
            }
        };
        this.myLocked = ContainerUtil.newHashSet();
        this.myContext = other.myContext;
        this.myExporter = other.myExporter;
        this.myModel = new DeModel(other.myModel, this);
    }

    public SchemaExportHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, @Nullable DasModel model) {
        if (exporter == null) {
            SchemaExportHelper.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SchemaExportHelper.$$$reportNull$$$0(3);
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myCopier = new /* invalid duplicate definition of identical inner class */;
        this.myLocked = ContainerUtil.newHashSet();
        this.myContext = context;
        this.myExporter = exporter;
        this.myModel = new DeModel(model, this);
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            SchemaExportHelper.$$$reportNull$$$0(4);
        }
        return databaseEditorContext;
    }

    @NotNull
    public SchemaExportHelper chained() {
        SchemaExportHelper schemaExportHelper = new SchemaExportHelper(this);
        if (schemaExportHelper == null) {
            SchemaExportHelper.$$$reportNull$$$0(5);
        }
        return schemaExportHelper;
    }

    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            SchemaExportHelper.$$$reportNull$$$0(6);
        }
        return deModel;
    }

    public boolean contains(@NotNull DasObject obj2) {
        if (obj2 == null) {
            SchemaExportHelper.$$$reportNull$$$0(7);
        }
        return this.myCache.containsKey(obj2);
    }

    public boolean canExport(@NotNull DasObject object) {
        if (object == null) {
            SchemaExportHelper.$$$reportNull$$$0(8);
        }
        return this.myExporter.get(object) != null;
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public <De extends DeObject> De export(@Nullable DasObject object, boolean withChildren) {
        if (object == null) {
            return null;
        }
        assert (object instanceof BasicElement || object instanceof DeObject) : "Unsupported object passed: " + object.getClass().getSimpleName();
        assert (object.getKind() != ObjectKind.ROOT) : "Root is not exportable";
        DeObject res2 = this.myCache.get(object);
        if (!(res2 == null || withChildren && res2.lightExported)) {
            return (De)res2;
        }
        SchemaExporters.Exporter<? extends DeObject, DasObject> exporter = this.myExporter.get(object);
        assert (exporter != null) : "No exporter for " + object.getClass().getName();
        if (res2 == null) {
            boolean wasFree = this.myLocked.add(object);
            assert (wasFree);
            assert (!(object instanceof DeObject) || ((DeObject)object).model != this.myModel);
            res2 = exporter.create(this, object);
            this.myLocked.remove(object);
            this.created(object, res2);
            res2.lightExported = true;
            exporter.lightExport(this, res2, object);
            if (res2.getParent() != null && res2.getParent().lightExported) {
                res2.getParent().addLightChild(res2);
            }
        }
        if (withChildren && res2.lightExported) {
            res2.lightChildren = null;
            res2.lightExported = false;
            exporter.exportChildren(this, res2, object);
        }
        return (De)res2;
    }

    protected void created(@NotNull DasObject object, @NotNull DeObject res2) {
        if (object == null) {
            SchemaExportHelper.$$$reportNull$$$0(9);
        }
        if (res2 == null) {
            SchemaExportHelper.$$$reportNull$$$0(10);
        }
        this.myCache.put(object, res2);
    }

    public <De extends DeObject> De exportDeep(@Nullable DasModel model, @NotNull DasObject object, boolean withChildren) {
        if (object == null) {
            SchemaExportHelper.$$$reportNull$$$0(11);
        }
        return (De)((DeObject)this.exportDeep(model, (Iterable<? extends DasObject>)JBIterable.of((Object)object), withChildren).first());
    }

    public <De extends DeObject> JBIterable<De> exportDeep(@Nullable DasModel model, @NotNull Iterable<? extends DasObject> objects, boolean withChildren) {
        JBIterable<De> unexported;
        if (objects == null) {
            SchemaExportHelper.$$$reportNull$$$0(12);
        }
        if (model == this.myModel) {
            return JBIterable.from(objects);
        }
        DasModel subModel = this.myModel.getModel();
        if (subModel != model) {
            assert (subModel instanceof DeModel);
            unexported = ((DeModel)subModel).getExportHelper().exportDeep(model, objects, withChildren);
        } else {
            unexported = JBIterable.from(objects);
        }
        return unexported.map(object -> this.export((DasObject)object, withChildren));
    }

    public void pullDependencies(@Nullable DasObject baseTarget) {
        Object obj2 = this.export(baseTarget, false);
        DeTable target = (DeTable)ObjectUtils.tryCast(obj2, DeTable.class);
        if (target == null) {
            DeTableChild child = (DeTableChild)ObjectUtils.tryCast(obj2, DeTableChild.class);
            DeTable deTable = target = child == null ? null : child.table;
        }
        if (target == null) {
            return;
        }
        if (FK_PULLED_MARK.get(target.flags) == Boolean.TRUE) {
            return;
        }
        target.model.getExportedKeys(target).size();
        FK_PULLED_MARK.set(target.flags, (Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaExportHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaExportHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chained";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canExport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exportDeep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

