/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nullable;

public class PlanRenderers {
    @Nullable
    public static Icon getIcon(PlanModel.GenericNode node) {
        PlanModel.NodeType nodeType = node.getType();
        if (nodeType.isKindOf(PlanModel.NodeType.SET_OP)) {
            return AllIcons.Toolbar.Filterdups;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.TEMPORARY)) {
            return DatabaseIcons.Table;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.SUBQUERY)) {
            return ((PlanModel.SubQueryNode)node).isCorrelated() ? AllIcons.Actions.Refresh : AllIcons.Actions.Rollback;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.SELECT)) {
            return DatabaseIcons.SqlSelectStatement;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.STATEMENT)) {
            return DatabaseIcons.SqlDmlStatement;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.INDEX_SCAN)) {
            return DatabaseIcons.GoldKey;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.DATA)) {
            return DatabaseIcons.Table;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.GROUP_BY)) {
            return DatabaseIcons.SqlGroupByType;
        }
        return null;
    }

    public static class ActionRenderer
    implements TreeCellRenderer {
        private final JLabel myLabel = new JLabel();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PlanTreeNode node = (PlanTreeNode)ObjectUtils.tryCast((Object)value, PlanTreeNode.class);
            this.myLabel.setForeground(UIUtil.getListForeground((boolean)selected));
            if (node == null) {
                this.myLabel.setIcon(null);
                this.myLabel.setText(null);
            } else {
                this.myLabel.setIcon(PlanRenderers.getIcon(node.getNode()));
                this.myLabel.setText(node.getNode().getDisplayTitle());
            }
            return this.myLabel;
        }
    }
}

