/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001c\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u001a\u0015\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a+\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0003*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\f\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0010\u001a$\u0010\u0011\u001a\u00020\u0012*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u001a\u000e\u0010\u0017\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u0018\u001a\u0016\u0010\u0017\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u0006\u0012\u0002\b\u00030\u0018\u001a\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001c\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u0006\u0012\u0002\b\u00030\u0018\u00a8\u0006 "}, d2={"checkRenameImpl", "", "o1", "Lcom/intellij/database/model/basic/BasicElement;", "o2", "equalOrNull", "a", "", "b", "getCase", "Lcom/intellij/database/util/Case;", "Lorg/jetbrains/annotations/NotNull;", "e", "cast", "Lcom/intellij/database/model/ElementAlteration;", "T", "(Lcom/intellij/database/model/ElementAlteration;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/ElementAlteration;", "commentStatement", "", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "type", "", "comment", "createOrReplace", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "kind", "Lcom/intellij/database/model/ObjectKind;", "ifNotExists", "isAlteredTo", "e1", "e2", "orReplace", "intellij.database.dialects"})
public final class BaseProducersKt {
    public static final boolean checkRenameImpl(@Nullable BasicElement o1, @Nullable BasicElement o2) {
        if (o1 == null || o2 == null) {
            return o1 != o2;
        }
        if (o1 instanceof BasicNamedElement && o2 instanceof BasicNamedElement && ((BasicNamedElement)o1).isNameSurrogate() && ((BasicNamedElement)o2).isNameSurrogate()) {
            return false;
        }
        Case c1 = BaseProducersKt.getCase(o1);
        Case c2 = BaseProducersKt.getCase(o2);
        return Intrinsics.areEqual((Object)c1.apply(o1.getName()), (Object)c2.apply(o2.getName())) ^ true;
    }

    private static final Case getCase(BasicElement e) {
        BasicModel basicModel = e.getModel();
        if (basicModel == null || (basicModel = basicModel.getCasing(e.getKind(), e)) == null) {
            basicModel = Casing.EXACT;
        }
        BasicElement basicElement = e;
        Case case_ = basicModel.choose(basicElement instanceof BasicNamedElement ? ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted() : false);
        Intrinsics.checkExpressionValueIsNotNull((Object)case_, (String)"(e.model?.getCasing(e.ki\u2026d\n    else -> false\n  }\n)");
        return case_;
    }

    @NotNull
    public static final <T extends BasicElement> ElementAlteration<T> cast(@NotNull ElementAlteration<?> $receiver, @NotNull T e) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        return $receiver;
    }

    @NotNull
    public static final String createOrReplace(@NotNull ElementProducer<?> $receiver, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return $receiver.getContext().getHelper().canCreateOrReplace(kind).get($receiver.getContext().getTask().getVersion()) != false ? BaseProducersKt.createOrReplace($receiver) : "create";
    }

    @NotNull
    public static final String createOrReplace(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return $receiver.getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false ? "create or replace" : "create";
    }

    @Nullable
    public static final String orReplace(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return $receiver.getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false ? "or replace" : null;
    }

    @Nullable
    public static final String ifNotExists(@NotNull ElementProducer<?> $receiver, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return $receiver.getContext().getHelper().canCreateIfNotExists(kind).get($receiver.getContext().getTask().getVersion()) != false ? BaseProducersKt.ifNotExists($receiver) : null;
    }

    @Nullable
    public static final String ifNotExists(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return $receiver.getContext().getOptions().get(ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) != false ? "if not exists" : null;
    }

    public static final void commentStatement(@NotNull CreateProducer<? extends BasicElement> $receiver, @NotNull String type, @Nullable String comment) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        $receiver.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>($receiver, type, comment){
            final /* synthetic */ CreateProducer receiver$0;
            final /* synthetic */ String $type;
            final /* synthetic */ String $comment;

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.plus($receiver.plus($receiver.plus($receiver.plus($receiver.unaryPlus("comment on"), this.$type), CreateProducer.fqName$default(this.receiver$0, false, 1, null)), "is"), this.receiver$0.commentStr(this.$comment));
            }
            {
                this.receiver$0 = createProducer;
                this.$type = string;
                this.$comment = string2;
                super(1);
            }
        }));
    }

    public static final boolean isAlteredTo(@NotNull ElementProducer<?> $receiver, @Nullable BasicElement e1, @Nullable BasicElement e2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        if (e1 == null || e2 == null) {
            return e1 == e2;
        }
        ElementDelta<?> elementDelta = $receiver.getContext().getBySource().get(e1);
        if (elementDelta != null) {
            ElementDelta<?> elementDelta2;
            ElementDelta<?> it = elementDelta2 = elementDelta;
            return Intrinsics.areEqual(it.getTargetElement(), (Object)e2);
        }
        ElementDelta<?> elementDelta3 = $receiver.getContext().getByTarget().get(e2);
        if (elementDelta3 != null) {
            ElementDelta<?> elementDelta4;
            ElementDelta<?> it = elementDelta4 = elementDelta3;
            return Intrinsics.areEqual(it.getSourceElement(), (Object)e1);
        }
        return Intrinsics.areEqual((Object)e1.getRealName(), (Object)e2.getRealName()) && BaseProducersKt.isAlteredTo($receiver, e1.getParent(), e2.getParent());
    }

    public static final boolean equalOrNull(@Nullable Object a, @Nullable Object b2) {
        return a == null || b2 == null || Intrinsics.areEqual((Object)a, (Object)b2);
    }
}

