/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.DatabaseAccessController;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleGridDataHookUp
extends DatabaseGridDataHookUp
implements JdbcConsole.SearchPathReceiver,
DataRequest.CustomSearchPathOwner {
    private static final Logger LOG = Logger.getInstance(ConsoleGridDataHookUp.class);
    private final DatabaseAccessController myController;
    private volatile AtomicReference<SearchPath> mySearchPath;
    private volatile boolean myValid;

    ConsoleGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @NotNull JdbcConsole.SearchPathSender sender) {
        if (project == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (sender == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(3);
        }
        super(project, session2, department);
        MyPathAuditor pathAuditor = new MyPathAuditor();
        Disposer.register((Disposable)this, (Disposable)pathAuditor);
        session2.getMessageBus().addAuditor(pathAuditor);
        sender.subscribe(this);
        this.myController = new DatabaseAccessController.PsiBasedReadOnly(this.getProject(), DbSqlUtil.getSqlDialect((LocalDataSource)session2.getTarget()), this.getDataSource(), () -> this.mySearchPath.get());
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        MyLoader myLoader = new MyLoader();
        if (myLoader == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(4);
        }
        return myLoader;
    }

    @Override
    @NotNull
    protected DataAuditor createAuditor() {
        MyBusAuditor myBusAuditor = new MyBusAuditor();
        if (myBusAuditor == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(5);
        }
        return myBusAuditor;
    }

    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public void receive(@Nullable SearchPath path) {
        this.validate(path, false);
    }

    private void validate(@Nullable SearchPath path, boolean supportSavepoints) {
        this.myValid = this.isStateValid(path, supportSavepoints);
    }

    private boolean isStateValid(@Nullable SearchPath path, boolean supportsSavepoints) {
        ObjectPath needed;
        ObjectPath current;
        boolean readOnly;
        if (this.mySearchPath == null) {
            LOG.debug("My search path reference is null");
            return false;
        }
        if (Comparing.equal((Object)this.mySearchPath.get(), (Object)path)) {
            return true;
        }
        if (this.mySearchPath.get() == null || path == null) {
            LOG.debug(this.mySearchPath.get() == null ? "My path is null" : "Current path is null");
            return false;
        }
        DbDataSource dbDataSource = this.getDataSource();
        if (!(dbDataSource.getDelegate() instanceof DatabaseConnectionPoint)) {
            LOG.debug("Delegate is not instance of connection point: " + dbDataSource.getDelegate().getClass().getName());
            return false;
        }
        DatabaseConnectionPoint point = (DatabaseConnectionPoint)dbDataSource.getDelegate();
        DatabaseDriver driver = point.getDatabaseDriver();
        if (JdbcUrlParserUtil.outOfBounds(driver, readOnly = point.isReadOnly(), current = path.getCurrent(), needed = this.mySearchPath.get().getCurrent())) {
            LOG.debug("Database changed");
            return false;
        }
        DataRequest.TxMarker tx = this.getCurrentTx();
        return supportsSavepoints || !tx.isTransactionInProgress();
    }

    @Override
    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath == null ? null : this.mySearchPath.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/ConsoleGridDataHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/ConsoleGridDataHookUp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyBusAuditor
    extends DataBusGridDataHookUp.BusAuditor {
        private MyBusAuditor() {
            super(ConsoleGridDataHookUp.this);
        }

        @Override
        protected boolean reloadOnRollback() {
            DbDataSource source = ConsoleGridDataHookUp.this.getDataSource();
            if (!source.isWritable()) {
                return true;
            }
            String query = ConsoleGridDataHookUp.this.getQueryText();
            return StringUtil.isEmptyOrSpaces((String)query) || ((ConsoleGridDataHookUp)ConsoleGridDataHookUp.this).myController.requestAccess((String)query).success;
        }
    }

    private class MyPathAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private MyPathAuditor() {
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyPathAuditor.$$$reportNull$$$0(0);
            }
            Boolean supportSavepoints = (Boolean)JdbcEngine.SUPPORTS_SAVEPOINTS_KEY.get((UserDataHolder)context);
            ConsoleGridDataHookUp.this.validate(context.getSearchPath(), supportSavepoints != null && supportSavepoints != false);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/ConsoleGridDataHookUp$MyPathAuditor", "requestFinished"));
        }
    }

    private class MyLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private MyLoader() {
            super(ConsoleGridDataHookUp.this);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                MyLoader.$$$reportNull$$$0(0);
            }
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
            ConsoleGridDataHookUp.this.mySearchPath = new AtomicReference<SearchPath>(context.getSearchPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/ConsoleGridDataHookUp$MyLoader", "setColumns"));
        }
    }
}

