/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.paint.RectanglePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import javax.swing.Icon;

public final class TextIcon
implements Icon {
    private static final FontRenderContext CONTEXT = new FontRenderContext(null, AntialiasingType.getKeyForCurrentScope((boolean)false), RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    private final Insets myInsets = new Insets(0, 0, 0, 0);
    private Integer myRound;
    private Color myBackground;
    private Color myForeground;
    private Font myFont;
    private String myText;
    private Rectangle myTextBounds;

    private Rectangle getTextBounds() {
        if (this.myTextBounds == null && this.myFont != null && this.myText != null && !this.myText.isEmpty()) {
            GlyphVector vector = this.myFont.createGlyphVector(CONTEXT, this.myText);
            this.myTextBounds = vector.getPixelBounds(CONTEXT, 0.0f, 0.0f);
        }
        return this.myTextBounds;
    }

    public TextIcon(String text, Color foreground, Color background, int margin) {
        this.setInsets(margin, margin, margin, margin);
        this.setRound(margin * 4);
        this.setBackground(background);
        this.setForeground(foreground);
        this.setText(text);
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.myInsets.set(top, left, bottom, right);
    }

    public void setInsets(Insets insets) {
        this.myInsets.set(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setRound(int round) {
        this.myRound = round;
    }

    public void setBackground(Color background) {
        this.myBackground = background;
    }

    public void setForeground(Color foreground) {
        this.myForeground = foreground;
    }

    public void setText(String text) {
        this.myTextBounds = null;
        this.myText = text;
    }

    public void setFont(Font font) {
        this.myFont = font;
        this.myTextBounds = null;
    }

    @Override
    public int getIconWidth() {
        Rectangle bounds2 = this.getTextBounds();
        return bounds2 == null ? 0 : this.myInsets.left + bounds2.width + this.myInsets.right;
    }

    @Override
    public int getIconHeight() {
        Rectangle bounds2 = this.getTextBounds();
        return bounds2 == null ? 0 : this.myInsets.top + bounds2.height + this.myInsets.bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.myBackground != null && g instanceof Graphics2D) {
            g.setColor(this.myBackground);
            RectanglePainter.FILL.paint((Graphics2D)g, x, y, this.getIconWidth(), this.getIconHeight(), (Object)this.myRound);
        }
        Rectangle bounds2 = this.getTextBounds();
        if (this.myForeground != null && bounds2 != null) {
            g = g.create();
            try {
                g.setColor(this.myForeground);
                g.setFont(this.myFont);
                UISettings.setupAntialiasing((Graphics)g);
                g.drawString(this.myText, this.myInsets.left + x - bounds2.x, this.myInsets.top + y - bounds2.y);
            }
            finally {
                g.dispose();
            }
        }
    }
}

