/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ShortcutsCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ActionsCollectorImpl
extends ActionsCollector
implements PersistentStateComponent<ActionsCollector.State> {
    private static final String DEFAULT_ID = "third.party.plugin.action";
    private static final HashMap<String, String> ourPrefixesBlackList = new HashMap();
    private ActionsCollector.State myState = new ActionsCollector.State();

    public void record(@Nullable String actionId, @NotNull Class context, @Nullable AnActionEvent event) {
        String inputEvent;
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        if (actionId == null) {
            return;
        }
        boolean isContextMenu = event != null && event.isFromContextMenu();
        String place = event != null ? event.getPlace() : "";
        boolean isDevelopedByJB = ActionsCollectorImpl.isDevelopedByJetBrains(context);
        String key = ActionsCollectorImpl.toReportedId(actionId, isDevelopedByJB);
        HashMap data = ContainerUtil.newHashMap(FUSUsageContext.OS_CONTEXT.getData());
        data.put("context_menu", isContextMenu);
        if (isContextMenu && isDevelopedByJB) {
            data.put("place", place);
        }
        if (StringUtil.isNotEmpty((String)(inputEvent = ShortcutsCollector.getInputEventText(event)))) {
            data.put("input_event", inputEvent);
        }
        FeatureUsageLogger.INSTANCE.log("actions.v2", key, (Map)data);
    }

    @NotNull
    private static String toReportedId(@NotNull String actionId, boolean isDevelopedByJB) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        if (!isDevelopedByJB) {
            if (DEFAULT_ID == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(2);
            }
            return DEFAULT_ID;
        }
        String key = ConvertUsagesUtil.escapeDescriptorName(actionId);
        for (Map.Entry<String, String> prefix : ourPrefixesBlackList.entrySet()) {
            if (!key.startsWith(prefix.getKey())) continue;
            String string = prefix.getValue();
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = key;
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean isDevelopedByJetBrains(@NotNull Class aClass) {
        if (aClass == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(5);
        }
        PluginId pluginId = PluginManagerCore.getPluginByClassName(aClass.getName());
        return StatisticsUtilKt.isDevelopedByJetBrains(pluginId);
    }

    @Nullable
    public ActionsCollector.State getState() {
        return this.myState;
    }

    public void loadState(@NotNull ActionsCollector.State state) {
        if (state == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(6);
        }
    }

    static {
        ourPrefixesBlackList.put("RemoteTool_", "Remote External Tool");
        ourPrefixesBlackList.put("Tool_", "External Tool");
        ourPrefixesBlackList.put("Ant_", "Ant_");
        ourPrefixesBlackList.put("Maven_", "Maven_");
        ourPrefixesBlackList.put("ExternalSystem_", "ExternalSystem_");
        ourPrefixesBlackList.put("Macro.", "Invoke Macro");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toReportedId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toReportedId";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

