/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryEventDispatcher
implements VirtualFileManagerListener,
CommandListener,
BulkFileListener,
VirtualFileListener {
    private static final Key<Boolean> WAS_VERSIONED_KEY = Key.create((String)(LocalHistoryEventDispatcher.class.getSimpleName() + ".WAS_VERSIONED_KEY"));
    private final LocalHistoryFacade myVcs;
    private final IdeaGateway myGateway;
    private final EventDispatcher<VirtualFileListener> myVfsEventsDispatcher = EventDispatcher.create(VirtualFileListener.class);

    public LocalHistoryEventDispatcher(LocalHistoryFacade vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myVfsEventsDispatcher.addListener((EventListener)((Object)this));
    }

    public void beforeRefreshStart(boolean asynchronous) {
        this.beginChangeSet();
    }

    public void afterRefreshFinish(boolean asynchronous) {
        this.endChangeSet(LocalHistoryBundle.message("system.label.external.change", new Object[0]));
    }

    public void commandStarted(@NotNull CommandEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(0);
        }
        this.beginChangeSet();
    }

    public void commandFinished(@NotNull CommandEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(1);
        }
        this.endChangeSet(e.getCommandName());
    }

    public void startAction() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.myVcs.forceBeginChangeSet();
    }

    public void finishAction(String name) {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.endChangeSet(name);
    }

    private void beginChangeSet() {
        this.myVcs.beginChangeSet();
    }

    private void endChangeSet(String name) {
        this.myVcs.endChangeSet(name);
    }

    public void fileCreated(@NotNull VirtualFileEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(2);
        }
        this.beginChangeSet();
        this.createRecursively(e.getFile());
        this.endChangeSet(null);
    }

    private void createRecursively(VirtualFile f) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile f) {
                if (f == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LocalHistoryEventDispatcher.this.isVersioned(f)) {
                    LocalHistoryEventDispatcher.this.myVcs.created(f.getPath(), f.isDirectory());
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                if (f == null) {
                    1.$$$reportNull$$$0(1);
                }
                return LocalHistoryEventDispatcher.this.myGateway.isVersioned(f, true) ? IdeaGateway.loadAndIterateChildren(f) : IdeaGateway.iterateDBChildren(f);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "f";
                objectArray2[1] = "com/intellij/history/integration/LocalHistoryEventDispatcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(3);
        }
        if (!this.areContentChangesVersioned(e)) {
            return;
        }
        VirtualFile f = e.getFile();
        Pair<StoredContent, Long> content = this.myGateway.acquireAndUpdateActualContent(f, null);
        if (content != null) {
            this.myVcs.contentChanged(f.getPath(), (Content)content.first, (Long)content.second);
        }
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(4);
        }
        if ("name".equals(e.getPropertyName())) {
            VirtualFile f = e.getFile();
            f.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f));
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(5);
        }
        if ("name".equals(e.getPropertyName())) {
            VirtualFile f = e.getFile();
            boolean isVersioned = this.myGateway.isVersioned(f);
            Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
            if (wasVersioned == null) {
                return;
            }
            f.putUserData(WAS_VERSIONED_KEY, null);
            if (!wasVersioned.booleanValue() && !isVersioned) {
                return;
            }
            String oldName = (String)e.getOldValue();
            this.myVcs.renamed(f.getPath(), oldName);
        } else if ("writable".equals(e.getPropertyName())) {
            if (!this.isVersioned(e.getFile())) {
                return;
            }
            VirtualFile f = e.getFile();
            if (!f.isDirectory()) {
                this.myVcs.readOnlyStatusChanged(f.getPath(), (Boolean)e.getOldValue() == false);
            }
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(6);
        }
        VirtualFile f = e.getFile();
        f.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f));
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(7);
        }
        VirtualFile f = e.getFile();
        boolean isVersioned = this.myGateway.isVersioned(f);
        Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
        if (wasVersioned == null) {
            return;
        }
        f.putUserData(WAS_VERSIONED_KEY, null);
        if (!wasVersioned.booleanValue() && !isVersioned) {
            return;
        }
        this.myVcs.moved(f.getPath(), e.getOldParent().getPath());
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent e) {
        VirtualFile f;
        Entry entry;
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(8);
        }
        if ((entry = this.myGateway.createEntryForDeletion(f = e.getFile())) != null) {
            this.myVcs.deleted(f.getPath(), entry);
        }
    }

    private boolean isVersioned(VirtualFile f) {
        return this.myGateway.isVersioned(f);
    }

    private boolean areContentChangesVersioned(VirtualFileEvent e) {
        return this.myGateway.areContentChangesVersioned(e.getFile());
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(9);
        }
        this.myGateway.runWithVfsEventsDispatchContext(events, true, () -> {
            if (events == null) {
                LocalHistoryEventDispatcher.$$$reportNull$$$0(12);
            }
            for (VFileEvent event : events) {
                BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)((VirtualFileListener)this.myVfsEventsDispatcher.getMulticaster()), (VFileEvent)event);
            }
        });
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(10);
        }
        this.myGateway.runWithVfsEventsDispatchContext(events, false, () -> {
            if (events == null) {
                LocalHistoryEventDispatcher.$$$reportNull$$$0(11);
            }
            for (VFileEvent event : events) {
                BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)((VirtualFileListener)this.myVfsEventsDispatcher.getMulticaster()), (VFileEvent)event);
            }
        });
    }

    public void addVirtualFileListener(VirtualFileListener virtualFileListener, Disposable disposable) {
        this.myVfsEventsDispatcher.addListener((EventListener)virtualFileListener, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/integration/LocalHistoryEventDispatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "commandStarted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeContentsChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileMovement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$after$1";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$before$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

