/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.Condition;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002J9\u0010\u001a\u001a\u0004\u0018\u00018\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00160\u001e\u00a2\u0006\u0002\u0010\u001fJ\"\u0010 \u001a\u00020\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#J3\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000#2\b\u0010&\u001a\u0004\u0018\u00018\u00002\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010(\u00a2\u0006\u0002\u0010)R-\u0010\u0006\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00018\u00008\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0003\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \t*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "T", "", "schemeManager", "Lcom/intellij/configurationStore/SchemeManagerImpl;", "(Lcom/intellij/configurationStore/SchemeManagerImpl;)V", "readOnlyExternalizableSchemes", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "getReadOnlyExternalizableSchemes", "()Ljava/util/concurrent/ConcurrentMap;", "schemes", "Lcom/intellij/util/containers/ConcurrentList;", "getSchemes", "()Lcom/intellij/util/containers/ConcurrentList;", "schemesRef", "Ljava/util/concurrent/atomic/AtomicReference;", "addScheme", "", "scheme", "replaceExisting", "", "(Ljava/lang/Object;Z)V", "collectExistingNames", "", "removeFirstScheme", "", "scheduleDelete", "condition", "Lkotlin/Function1;", "(Ljava/util/List;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "replaceSchemeList", "oldList", "newList", "", "setSchemes", "newSchemes", "newCurrentScheme", "removeCondition", "Lcom/intellij/openapi/util/Condition;", "(Ljava/util/List;Ljava/lang/Object;Lcom/intellij/openapi/util/Condition;)V", "intellij.platform.configurationStore.impl"})
public final class SchemeListManager<T> {
    private final AtomicReference<ConcurrentList<T>> schemesRef;
    @NotNull
    private final ConcurrentMap<String, T> readOnlyExternalizableSchemes;
    private final SchemeManagerImpl<T, ?> schemeManager;

    @NotNull
    public final ConcurrentMap<String, T> getReadOnlyExternalizableSchemes() {
        return this.readOnlyExternalizableSchemes;
    }

    @NotNull
    public final ConcurrentList<T> getSchemes() {
        ConcurrentList<T> concurrentList = this.schemesRef.get();
        Intrinsics.checkExpressionValueIsNotNull(concurrentList, (String)"schemesRef.get()");
        return concurrentList;
    }

    public final void replaceSchemeList(@NotNull ConcurrentList<T> oldList, @NotNull List<? extends T> newList) {
        Intrinsics.checkParameterIsNotNull(oldList, (String)"oldList");
        Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList((Collection)newList);
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.containers.ConcurrentList<T>");
        }
        if (!this.schemesRef.compareAndSet(oldList, (ConcurrentList)list2)) {
            throw (Throwable)new IllegalStateException("Scheme list was modified");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addScheme(@NotNull T scheme2, boolean replaceExisting) {
        Object object;
        Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
        int toReplace = -1;
        ConcurrentList<T> schemes = this.getSchemes();
        SchemeProcessor processor2 = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        ConcurrentMap<T, ExternalInfo> schemeToInfo = this.schemeManager.getSchemeToInfo$intellij_platform_configurationStore_impl();
        boolean bl = false;
        Iterator iterator = ((Iterable)schemes).iterator();
        while (iterator.hasNext()) {
            void index;
            Object existing;
            Object t = existing = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"existing");
            if (!(Intrinsics.areEqual((Object)processor2.getSchemeKey(t), (Object)processor2.getSchemeKey(scheme2)) ^ true)) {
                ExternalInfo oldInfo;
                toReplace = index;
                if (existing == scheme2) break;
                if (Intrinsics.areEqual(existing.getClass(), scheme2.getClass()) ^ true) {
                    ComponentStoreImplKt.getLOG().warn('\'' + processor2.getSchemeKey(scheme2) + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme2.getClass().getSimpleName());
                }
                if (replaceExisting && processor2.isExternalizable(existing) && (oldInfo = (ExternalInfo)schemeToInfo.remove(existing)) != null && processor2.isExternalizable(scheme2) && !schemeToInfo.containsKey(scheme2)) {
                    schemeToInfo.put(scheme2, oldInfo);
                }
            }
            ++index;
        }
        if (toReplace == -1) {
            schemes.add(scheme2);
        } else if (replaceExisting || !processor2.isExternalizable(scheme2)) {
            if (schemes.get(toReplace) != scheme2) {
                schemes.set(toReplace, scheme2);
            }
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme2;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme2).getName(), this.collectExistingNames((Collection)schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            SchemeManagerUtilKt.renameScheme(externalizableScheme, string);
            schemes.add(scheme2);
        }
        if (processor2.isExternalizable(scheme2) && !(object = (Collection)this.schemeManager.getFilesToDelete$intellij_platform_configurationStore_impl()).isEmpty()) {
            ExternalInfo externalInfo = (ExternalInfo)schemeToInfo.get(scheme2);
            if (externalInfo != null) {
                Object it = object = externalInfo;
                this.schemeManager.getFilesToDelete$intellij_platform_configurationStore_impl().remove(((ExternalInfo)it).getFileName());
            }
        }
        this.schemeManager.processPendingCurrentSchemeName$intellij_platform_configurationStore_impl(scheme2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        block11: {
            List list2;
            AtomicReference<ConcurrentList<T>> atomicReference;
            block13: {
                List list3;
                void $receiver$iv;
                Collection collection;
                block12: {
                    Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
                    collection = (Collection)this.getSchemes();
                    if (!(!collection.isEmpty())) break block11;
                    if (removeCondition != null) break block12;
                    this.getSchemes().clear();
                    break block11;
                }
                collection = (Collection)this.getSchemes();
                atomicReference = this.schemesRef;
                switch ($receiver$iv.size()) {
                    case 1: {
                        list3 = (List)new SmartList();
                        break;
                    }
                    case 0: {
                        list2 = CollectionsKt.emptyList();
                        break block13;
                    }
                    default: {
                        list3 = new ArrayList();
                    }
                }
                List result$iv = list3;
                Iterable $receiver$iv$iv = (Iterable)$receiver$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Object it = element$iv$iv;
                    if (!(!removeCondition.value(it))) continue;
                    ((Collection)result$iv).add(element$iv$iv);
                }
                list2 = result$iv;
            }
            List list4 = list2;
            atomicReference.set(ContainerUtil.createConcurrentList((Collection)list4));
        }
        this.getSchemes().addAll((Collection)newSchemes);
        Object oldCurrentScheme = this.schemeManager.getActiveScheme();
        this.schemeManager.retainExternalInfo$intellij_platform_configurationStore_impl();
        if (Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme) ^ true) {
            Object newScheme;
            if (newCurrentScheme != null) {
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newCurrentScheme);
                newScheme = newCurrentScheme;
            } else if (oldCurrentScheme != null && !this.getSchemes().contains(oldCurrentScheme)) {
                newScheme = CollectionsKt.firstOrNull((List)((List)this.getSchemes()));
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newScheme);
            } else {
                newScheme = null;
            }
            if (Intrinsics.areEqual(oldCurrentScheme, newScheme) ^ true) {
                this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().onCurrentSchemeSwitched(oldCurrentScheme, newScheme);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> collectExistingNames(Collection<? extends T> schemes) {
        THashSet result2 = new THashSet(schemes.size());
        Iterable $receiver$iv = schemes;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv;
            Object t = item$iv = iterator.next();
            Collection collection = (Collection)result2;
            String string = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it);
            collection.add(string);
        }
        Collection cfr_ignored_0 = (Collection)result2;
        return (Collection)result2;
    }

    @Nullable
    public final T removeFirstScheme(@NotNull List<T> schemes, boolean scheduleDelete, @NotNull Function1<? super T, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        Iterator<T> iterator = schemes.iterator();
        Object object = iterator;
        Iterator<T> iterator2 = object;
        while (iterator2.hasNext()) {
            T scheme2 = iterator2.next();
            if (!((Boolean)condition.invoke(scheme2)).booleanValue()) continue;
            if (this.schemeManager.getActiveScheme() == scheme2) {
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(null);
            }
            iterator.remove();
            if (scheduleDelete && this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().isExternalizable(scheme2)) {
                ExternalInfo externalInfo = (ExternalInfo)this.schemeManager.getSchemeToInfo$intellij_platform_configurationStore_impl().remove(scheme2);
                if (externalInfo != null) {
                    object = externalInfo;
                    SchemeManagerImpl<T, ?> schemeManagerImpl = this.schemeManager;
                    Object p1 = object;
                    schemeManagerImpl.scheduleDelete$intellij_platform_configurationStore_impl((ExternalInfo)p1);
                }
            }
            return scheme2;
        }
        return null;
    }

    @Nullable
    public static /* synthetic */ Object removeFirstScheme$default(SchemeListManager schemeListManager, List list2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemeListManager.removeFirstScheme(list2, bl, function1);
    }

    public SchemeListManager(@NotNull SchemeManagerImpl<T, ?> schemeManager2) {
        Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
        this.schemeManager = schemeManager2;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.containers.ConcurrentList<T>");
        }
        this.schemesRef = new AtomicReference<ConcurrentList>((ConcurrentList)list2);
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<String, T>()");
        this.readOnlyExternalizableSchemes = concurrentMap;
    }
}

