/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerConnector
extends ServerConnector<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerConnector.class);
    public static final ClientLibraryDescription Docker = new ClientLibraryDescription("docker-2.6.1", DockerConnector.class.getResource("/resources/DockerClientLib.xml"));
    private static final String RUNTIME_FOLDER = "rt";
    private static final String FROM_SOURCES_LIBS_DOCKER_JAVA = "lib-docker-java";
    private static final String FROM_SOURCES_LIBS_DEFAULT = "lib";
    private final DockerCloudConfiguration myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;

    public DockerConnector(DockerCloudConfiguration configuration, ServerTaskExecutor tasksExecutor) {
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(@NotNull ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        if (callback == null) {
            DockerConnector.$$$reportNull$$$0(0);
        }
        this.myTasksExecutor.submit(() -> {
            List clientLibrary;
            if (callback == null) {
                DockerConnector.$$$reportNull$$$0(3);
            }
            if ((clientLibrary = DockerConnector.loadBundledClientLibrary()) == null) {
                try {
                    clientLibrary = ClientLibraryManager.getInstance().download(Docker);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    callback.errorOccurred("Failed to download client libraries: " + e.getMessage());
                    return;
                }
            }
            new DockerServerRuntimeInstance(this.myConfiguration, this.myTasksExecutor, clientLibrary).connect(callback);
        }, callback);
    }

    @Nullable
    public static List<File> loadBundledClientLibrary() {
        File clientJar = new File(PathUtil.getJarPathForClass(DockerConnector.class));
        if (clientJar.isDirectory()) {
            String ultimateSourcesFolder = PathManager.getHomePath();
            Path docker = Paths.get(ultimateSourcesFolder, "plugins", "Docker");
            Path implRt = docker.resolve("Docker-agent-impl-rt");
            Path apiRt = docker.resolve("Docker-agent-api-rt");
            return DockerConnector.listBundledClientLibrary(implRt.resolve(FROM_SOURCES_LIBS_DOCKER_JAVA), implRt.resolve(FROM_SOURCES_LIBS_DEFAULT), apiRt.resolve(FROM_SOURCES_LIBS_DEFAULT));
        }
        File runtimeFolder = new File(clientJar.getParentFile(), RUNTIME_FOLDER);
        return DockerConnector.listBundledClientLibrary(runtimeFolder);
    }

    @Nullable
    private static List<File> listBundledClientLibrary(Path ... clientFolderPaths) {
        if (clientFolderPaths == null) {
            DockerConnector.$$$reportNull$$$0(1);
        }
        return DockerConnector.listBundledClientLibrary((File[])Stream.of(clientFolderPaths).map(Path::toFile).toArray(File[]::new));
    }

    @Nullable
    private static List<File> listBundledClientLibrary(File ... clientFolders) {
        if (clientFolders == null) {
            DockerConnector.$$$reportNull$$$0(2);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File nextFolder : clientFolders) {
            File[] clientFiles = nextFolder.listFiles();
            if (clientFiles == null) {
                LOG.info("Unable to load bundled client library files from " + nextFolder);
                return null;
            }
            result.addAll(Arrays.asList(clientFiles));
            LOG.debug("Bundled client library loaded from " + nextFolder);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientFolderPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientFolders";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerConnector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "connect";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "listBundledClientLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$connect$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

