/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import b.h.la;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.utils.MarkupConstants;

public class RubyDocumentationMarkupUtil
implements MarkupConstants {
    @NonNls
    private static final String a = "</font>";
    private static final Pattern b;
    private static final long c;

    public static String processCodeDocumentation(@Nullable Symbol target, @NonNls @NotNull String text) {
        IElementType iElementType;
        long l2 = c ^ 0x67059F7FBB7EL;
        if (text == null) {
            RubyDocumentationMarkupUtil.a(0);
        }
        text = text.trim();
        text = text.replaceAll("^##+\\n", "");
        text = text.replaceAll("(^#)|((?<=\\n)#)", "");
        text = RubyDocumentationMarkupUtil.f(text);
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = RubyDocumentationMarkupUtil.c(text);
        Colorer colorer = new Colorer();
        StringBuilder stringBuilder = new StringBuilder();
        RDocLexer rDocLexer = new RDocLexer(true, true);
        rDocLexer.start(text);
        IElementType iElementType2 = null;
        IElementType iElementType3 = null;
        while ((iElementType = rDocLexer.getTokenType()) != null) {
            String string = rDocLexer.getTokenText();
            if (iElementType == RDocTokenTypes.HEADINGS) {
                RubyDocumentationMarkupUtil.a(stringBuilder, string);
            } else if (iElementType == RDocTokenTypes.RULE) {
                stringBuilder.append("<hr>");
            } else if (iElementType == RDocTokenTypes.ITALIC) {
                stringBuilder.append("<em>").append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append("</em>");
            } else if (iElementType == RDocTokenTypes.BOLD) {
                stringBuilder.append("<b>").append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append("</b>");
            } else if (iElementType == RDocTokenTypes.TYPE_WRITER) {
                stringBuilder.append("<code>").append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append("</code>");
            } else if (iElementType == RDocTokenTypes.DIRECTIVE) {
                stringBuilder.append(colorer.c()).append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append(a);
            } else if (iElementType == RDocTokenTypes.INTEGER || iElementType == RDocTokenTypes.FLOAT) {
                stringBuilder.append("<em>").append("<code>").append(colorer.a()).append(string).append(a).append("</code>").append("</em>");
            } else if (iElementType == RDocTokenTypes.STRING) {
                stringBuilder.append("<b>").append("<code>").append(colorer.e()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.VAR) {
                stringBuilder.append("<b>").append("<em>").append("<code>").append(colorer.d()).append(string).append(a).append("</code>").append("</em>").append("</b>");
            } else if (iElementType == RDocTokenTypes.GVAR) {
                stringBuilder.append("<b>").append("<code>").append(colorer.g()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.SYMBOL) {
                stringBuilder.append("<b>").append("<code>").append(colorer.f()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.RESWORD || iElementType == RDocTokenTypes.PARAM || iElementType == RDocTokenTypes.RETURN) {
                stringBuilder.append("<b>").append("<code>").append(colorer.b()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.URL) {
                stringBuilder.append(Matcher.quoteReplacement("<a href=\"" + string + "\">" + string + "</a>"));
            } else if (iElementType == RDocTokenTypes.EMAIL) {
                stringBuilder.append(Matcher.quoteReplacement("<a href=\"mailto:" + string + "\">" + string + "</a>"));
            } else if (target != null && (iElementType == RDocTokenTypes.TYPE || iElementType == RDocTokenTypes.CID)) {
                boolean bl2 = iElementType3 != RDocTokenTypes.CID || iElementType2 != RDocTokenTypes.HASH;
                boolean bl3 = Character.isUpperCase(string.charAt(0));
                Symbol symbol = RubyDocumentationMarkupUtil.a(target, string, bl3);
                if (symbol != null) {
                    stringBuilder.append(RubyHelpUtil.createRefText(symbol, !bl2));
                } else {
                    stringBuilder.append(string);
                }
            } else {
                stringBuilder.append(string);
            }
            rDocLexer.advance();
            iElementType3 = iElementType2;
            iElementType2 = iElementType;
        }
        text = RubyDocumentationMarkupUtil.e(stringBuilder.toString());
        text = RubyDocumentationMarkupUtil.d(text);
        text = RubyDocumentationMarkupUtil.b(text);
        return text.replaceAll("\\n", "<br>").replaceAll("--", "&ndash;");
    }

    @Nullable
    private static Symbol a(Symbol symbol, String string, boolean bl2) {
        PsiElement psiElement = symbol.getPsiElement();
        if (!(psiElement instanceof RPsiElement)) {
            return null;
        }
        Symbol symbol2 = SymbolUtil.getScopeContext(symbol);
        if (symbol2 == null) {
            return null;
        }
        FQN fQN = FQN.Builder.fromString((String)string);
        return bl2 ? SymbolUtil.lookupConstant(symbol2, (RPsiElement)psiElement, fQN, Types.MODULE_OR_CLASS, psiElement) : SymbolUtil.lookupMethod(symbol2, fQN, Types.MODULE_OR_CLASS, Context.INSTANCE_PRIVATE, psiElement);
    }

    private static void a(StringBuilder stringBuilder, String string) {
        int n2;
        long l2 = c ^ 0x74C39977F171L;
        String string2 = string.trim();
        for (n2 = 0; n2 < string2.length() && string2.charAt(n2) == '='; ++n2) {
        }
        stringBuilder.append("<h" + (n2 + 1) + ">" + Matcher.quoteReplacement(string2.substring(n2).trim()) + "</h" + (n2 + 1) + ">");
    }

    public static String processGemDocumentation(@NonNls @NotNull String text) {
        if (text == null) {
            RubyDocumentationMarkupUtil.a(1);
        }
        return RubyDocumentationMarkupUtil.processCodeDocumentation(null, text);
    }

    private static String b(String string) {
        long l2 = c ^ 0x11F830E49571L;
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = b.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i10 = 0; i10 < n2; ++i10) {
                stringBuilder.append("&nbsp;");
            }
            matcher.appendReplacement(stringBuffer, stringBuilder.toString());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String f(String string) {
        long l2 = c ^ 0x5DD244125C83L;
        string = string.replaceAll("<b>", "B_OPEN_TAG");
        string = string.replaceAll("</b>", "B_CLOSE_TAG");
        string = string.replaceAll("<em>", "EM_OPEN_TAG");
        string = string.replaceAll("</em>", "EM_CLOSE_TAG");
        string = string.replaceAll("<i>", "EM_OPEN_TAG");
        string = string.replaceAll("</i>", "EM_CLOSE_TAG");
        string = string.replaceAll("<tt>", "TT_OPEN_TAG");
        string = string.replaceAll("</tt>", "TT_CLOSE_TAG");
        string = string.replaceAll("<code>", "CODE_OPEN_TAG");
        string = string.replaceAll("</code>", "CODE_CLOSE_TAG");
        string = string.replaceAll("<h1>", "H_OPEN_TAG_ONE");
        string = string.replaceAll("</h1>", "H_CLOSE_TAG_ONE");
        string = string.replaceAll("<h2>", "H_OPEN_TAG_TWO");
        string = string.replaceAll("</h2>", "H_CLOSE_TAG_TWO");
        string = string.replaceAll("<h3>", "H_OPEN_TAG_THREE");
        string = string.replaceAll("</h3>", "H_CLOSE_TAG_THREE");
        string = string.replaceAll("<h4>", "H_OPEN_TAG_FOUR");
        string = string.replaceAll("</h4>", "H_CLOSE_TAG_FOUR");
        return string;
    }

    private static String e(String string) {
        long l2 = c ^ 0x7BBE95FA35AL;
        string = string.replaceAll("B_OPEN_TAG", "<b>");
        string = string.replaceAll("B_CLOSE_TAG", "</b>");
        string = string.replaceAll("EM_OPEN_TAG", "<em>");
        string = string.replaceAll("EM_CLOSE_TAG", "</em>");
        string = string.replaceAll("TT_OPEN_TAG", "<tt>");
        string = string.replaceAll("TT_CLOSE_TAG", "</tt>");
        string = string.replaceAll("CODE_OPEN_TAG", "<code>");
        string = string.replaceAll("CODE_CLOSE_TAG", "</code>");
        string = string.replaceAll("H_OPEN_TAG_ONE", "<h1>");
        string = string.replaceAll("H_CLOSE_TAG_ONE", "</h1>");
        string = string.replaceAll("H_OPEN_TAG_TWO", "<h2>");
        string = string.replaceAll("H_CLOSE_TAG_TWO", "</h2>");
        string = string.replaceAll("H_OPEN_TAG_THREE", "<h3>");
        string = string.replaceAll("H_CLOSE_TAG_THREE", "</h3>");
        string = string.replaceAll("H_OPEN_TAG_FOUR", "<h4>");
        string = string.replaceAll("H_CLOSE_TAG_FOUR", "</h4>");
        return string;
    }

    private static String d(String string) {
        long l2 = c ^ 0x55413FE44C21L;
        ArrayList<String> arrayList = RubyDocumentationMarkupUtil.a(string);
        if (arrayList.size() == 1) {
            return string;
        }
        int n2 = -1;
        String string2 = " ";
        String string3 = "     ";
        for (int i10 = 0; i10 < arrayList.size(); ++i10) {
            String string4 = arrayList.get(i10);
            if (StringUtil.isEmptyOrSpaces((String)string4)) continue;
            if (string4.startsWith("     ")) {
                if (n2 != -1) continue;
                n2 = i10;
                continue;
            }
            if (n2 != -1) {
                return string;
            }
            if (string4.startsWith(" ")) continue;
            return string;
        }
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h3>").append(RBundle.message((String)"ruby.doc.usage")).append(":</h3>");
        for (int i11 = 0; i11 < arrayList.size(); ++i11) {
            if (i11 == n2) {
                stringBuilder.append("<h3>").append(RBundle.message((String)"ruby.doc.description")).append(":</h3>");
            } else if (i11 > 0) {
                stringBuilder.append("\n");
            }
            String string5 = arrayList.get(i11);
            if (StringUtil.isEmptyOrSpaces((String)string5)) {
                stringBuilder.append(string5);
                continue;
            }
            if (i11 < n2) {
                stringBuilder.append(string5);
                continue;
            }
            stringBuilder.append(string5.substring(4));
        }
        return stringBuilder.toString();
    }

    private static String c(String string) {
        long l2 = c ^ 0x72A59E4C8A28L;
        ArrayList<String> arrayList = RubyDocumentationMarkupUtil.a(string);
        if (arrayList.size() == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        for (String string4 : arrayList) {
            if (bl2) {
                if (StringUtil.isEmptyOrSpaces((String)string4)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(string4);
                }
                if (string4.startsWith(string3)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(string4.substring(n2));
                    continue;
                }
                if (string4.startsWith(string2)) {
                    stringBuilder.append("</li><li>");
                    stringBuilder.append(string4.substring(n2));
                    continue;
                }
                bl2 = false;
                stringBuilder.append("</li></ul>");
                stringBuilder.append(string4);
                continue;
            }
            string2 = RubyDocumentationMarkupUtil.g(string4);
            if (string2 != null) {
                bl2 = true;
                string3 = string2.replaceAll("\\*", " ");
                n2 = string2.length();
                stringBuilder.append("<ul><li>").append(string4.substring(n2));
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string4);
        }
        if (bl2) {
            stringBuilder.append("</li></ul>");
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static String g(String string) {
        long l2 = c ^ 0x9C17636E639L;
        Matcher matcher = Pattern.compile("^([ ]*\\*[ ]+)").matcher(string);
        return matcher.find() ? matcher.group() : null;
    }

    private static ArrayList<String> a(String string) {
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = string.indexOf(10, n3)) != -1) {
            arrayList.add(string.substring(n3, n2));
            n3 = n2 + 1;
        }
        arrayList.add(string.substring(n3));
        return arrayList;
    }

    public static void appendBold(@NotNull StringBuilder builder, @Nullable String s2) {
        long l2 = c ^ 0x1A7A7147745BL;
        if (builder == null) {
            RubyDocumentationMarkupUtil.a(2);
        }
        builder.append("<b>").append(s2).append("</b>");
    }

    public static void appendCode(@NotNull StringBuilder builder, @Nullable String s2) {
        long l2 = c ^ 0x70EB2377511AL;
        if (builder == null) {
            RubyDocumentationMarkupUtil.a(3);
        }
        builder.append("<code>").append(s2).append("</code>");
    }

    public static void appendBoldCode(@NotNull StringBuilder builder, @Nullable String s2) {
        long l2 = c ^ 0xEEC0AB5F10FL;
        if (builder == null) {
            RubyDocumentationMarkupUtil.a(4);
        }
        builder.append("<b>").append("<code>").append(s2).append("</code>").append("</b>");
    }

    static {
        c = la.a(-7759541473994754745L, 8397277088594139364L, MethodHandles.lookup().lookupClass()).a(135810168080518L);
        long l2 = c ^ 0x4B3CF52165C0L;
        b = Pattern.compile("(^[ ]{2,})|((?<=\\n)[ ]{2,})");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0xAAF507812E3L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationMarkupUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCodeDocumentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processGemDocumentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBold";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBoldCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Colorer {
        private final String b;
        private final String e;
        private final String f;
        private final String g;
        private final String c;
        private final String d;
        private final String a;
        private static final long h = la.a(-1411308202684746442L, 7546411899105431577L, MethodHandles.lookup().lookupClass()).a(52666053729139L);

        private static String a(TextAttributesKey textAttributesKey) {
            long l2 = h ^ 0x5934CF9BC0B8L;
            Color color = textAttributesKey.getDefaultAttributes().getForegroundColor();
            return color != null ? "<font color=#" + ColorUtil.toHex((Color)color) + ">" : "";
        }

        Colorer() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.b = "<font color=#0000FF>";
                this.e = "<font color=#000066>";
                this.f = "<font color=#0000FF>";
                this.g = "<font color=#006600>";
                this.c = "<font color=#0099FF>";
                this.d = "<font color=#9900FF>";
                this.a = "<font color=#000000>";
            } else {
                this.b = Colorer.a(RubyHighlighter.NUMBER);
                this.e = Colorer.a(RubyHighlighter.KEYWORD);
                this.f = Colorer.a(RubyHighlighter.NUMBER);
                this.g = Colorer.a(RubyHighlighter.SIMPLE_STRING);
                this.c = Colorer.a(RubyHighlighter.SYMBOL);
                this.d = Colorer.a(RubyHighlighter.IVAR);
                this.a = Colorer.a(RubyHighlighter.GVAR);
            }
        }

        private String c() {
            return this.b;
        }

        private String b() {
            return this.e;
        }

        private String a() {
            return this.f;
        }

        private String e() {
            return this.g;
        }

        private String f() {
            return this.c;
        }

        private String d() {
            return this.d;
        }

        private String g() {
            return this.a;
        }
    }
}

