/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import b.h.la;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;

public class RubyExecutionStack
extends XExecutionStack {
    @NotNull
    private final List<RubyStackFrame> a;
    private RubyStackFrame c;
    private static final Logger b;
    private static final long d;

    public RubyExecutionStack(Project project, SourcePositionConverter positionConverter, RubyDebuggerProxy debuggerProxy, RubyThreadInfo rubyThreadInfo, RubyThread rubyThread, boolean processPaused) {
        long l2 = d ^ 0x490B5A81588L;
        super(RubyExecutionStack.a(rubyThreadInfo), rubyThread.isSuspended() ? AllIcons.Debugger.ThreadAtBreakpoint : AllIcons.Debugger.ThreadSuspended);
        this.c = null;
        if (!debuggerProxy.waitForDebuggerProxyReady()) {
            b.warn("Couldn't evaluate execution stack during timeout");
            this.a = Collections.emptyList();
            return;
        }
        if (processPaused && rubyThread.supportsFrameReading()) {
            this.a = new ArrayList<RubyStackFrame>();
            try {
                RubyFrame[] rubyFrameArray = rubyThread.getFrames();
                RubyFrame rubyFrame = rubyThread.getTopFrame();
                for (RubyFrame rubyFrame2 : rubyFrameArray) {
                    RubyStackFrame rubyStackFrame = new RubyStackFrame(project, positionConverter, debuggerProxy, rubyThread, rubyFrame2);
                    this.a.add(rubyStackFrame);
                    if (rubyFrame != rubyFrame2) continue;
                    this.c = rubyStackFrame;
                }
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                this.a.clear();
                this.c = null;
            }
        } else {
            this.a = Collections.emptyList();
            this.c = null;
        }
    }

    private static String a(RubyThreadInfo rubyThreadInfo) {
        long l2 = d ^ 0x33F123346B5EL;
        int n2 = rubyThreadInfo.getPid();
        return "Thread " + rubyThreadInfo.getId() + " [" + rubyThreadInfo.getStatus() + "]" + (n2 != -1 ? " (pid " + n2 + ")" : "");
    }

    public XStackFrame getTopFrame() {
        return this.c;
    }

    public void computeStackFrames(int frameCount, XExecutionStack.XStackFrameContainer container) {
        long l2 = d ^ 0x7A6C8530BB3DL;
        if (frameCount <= this.a.size()) {
            List<RubyStackFrame> list2 = this.a.subList(frameCount, this.a.size());
            if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                list2 = list2.stream().filter(rubyStackFrame -> rubyStackFrame.isInProjectFrame()).collect(Collectors.toList());
            }
            container.addStackFrames(list2, true);
        } else {
            container.errorOccurred(RBundle.message((String)"ruby.debugger.no.stackframes.available"));
        }
    }

    public boolean equals(Object other) {
        return other instanceof RubyExecutionStack && this.getDisplayName().equals(((RubyExecutionStack)((Object)other)).getDisplayName());
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    static {
        d = la.a(-6851976450228927396L, -6230144285790271259L, MethodHandles.lookup().lookupClass()).a(184455957467719L);
        b = Logger.getInstance(RubyExecutionStack.class);
    }
}

