/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import b.h.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public abstract class InflectorService {
    public static final Topic<Runnable> INFLECTIONS_CHANGED;
    @NonNls
    protected static final String UNCOUNTABLE = "uncountable";
    @NonNls
    protected static final String PLURAL = "plural";
    @NonNls
    protected static final String SINGULAR = "singular";
    @NonNls
    protected static final String IRREGULAR = "irregular";
    @NonNls
    private static final String c = "inflections";
    @NonNls
    private static final String b = "clear";
    protected final Module myModule;
    protected final RailsApp myApp;
    protected final Map<String, String> myClassifyCache = ContainerUtil.newConcurrentMap();
    protected final Map<String, String> myTableizeCache = ContainerUtil.newConcurrentMap();
    protected final Map<String, String> mySingularizeCache = ContainerUtil.newConcurrentMap();
    protected final Map<String, String> myPluralizeCache = ContainerUtil.newConcurrentMap();
    private PsiCallable a = new InflectorCallable();
    private static final long f;

    public InflectorService(Module module) {
        this.myModule = module;
        this.myApp = RailsApp.fromModule(this.myModule);
        PsiManager.getInstance((Project)module.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){
            private static final long a = la.a(-2378899065031508447L, -1723555960925588317L, MethodHandles.lookup().lookupClass()).a(139587265298121L);

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(0);
                }
                InflectorService.this.a(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(1);
                }
                InflectorService.this.a(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(2);
                }
                InflectorService.this.a(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(3);
                }
                InflectorService.this.a(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(4);
                }
                InflectorService.this.a(event);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x13DE1514B357L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/InflectorService$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myModule);
    }

    public static InflectorService getInstance(@NotNull Module module) {
        if (module == null) {
            InflectorService.a(0);
        }
        return (InflectorService)ModuleServiceManager.getService((Module)module, InflectorService.class);
    }

    private void a(PsiTreeChangeEvent psiTreeChangeEvent) {
        String string;
        long l2 = f ^ 0x5966AB1B6F48L;
        PsiFile psiFile = psiTreeChangeEvent.getFile();
        PsiElement psiElement = psiTreeChangeEvent.getChild();
        if (psiFile == null && psiElement instanceof PsiFile) {
            psiFile = (PsiFile)psiElement;
        }
        String string2 = string = psiFile != null ? psiFile.getName() : null;
        if ("environment.rb".equals(string) || "inflections.rb".equals(string)) {
            this.clearCaches();
        }
    }

    public void clearCaches() {
        this.myPluralizeCache.clear();
        this.mySingularizeCache.clear();
        this.myClassifyCache.clear();
        this.myTableizeCache.clear();
        ((Runnable)this.myModule.getMessageBus().syncPublisher(INFLECTIONS_CHANGED)).run();
    }

    @Nullable
    protected static PsiFile getInflections(Module module, RailsApp app) {
        long l2 = f ^ 0x4DD72261A3F2L;
        if (app == null) {
            return null;
        }
        VirtualFile virtualFile = app.getConfigRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath("initializers/inflections.rb");
        return virtualFile2 != null ? PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile2) : null;
    }

    public abstract boolean isInflectorAvailable();

    @Nullable
    public abstract String classify(String var1);

    @Nullable
    public abstract String tableize(String var1);

    @Nullable
    public abstract String singularize(String var1);

    @Nullable
    public abstract String pluralize(String var1);

    protected void updateInflectionExceptions(@Nullable PsiFile file) {
        if (!(file instanceof RFile)) {
            return;
        }
        this.loadInflectionExceptions((RContainer)((RFile)file));
    }

    protected void loadInflectionExceptions(@NotNull RContainer container) {
        long l2 = f ^ 0x1CF38E4E44AEL;
        if (container == null) {
            InflectorService.a(1);
        }
        this.a = this.a != null ? this.a : new InflectorCallable();
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        rubyPsiInterpreter.registerCallable(this.a, "Inflector.inflections", "ActiveSupport::Inflector.inflections", "Inflector", "ActiveSupport::Inflector");
        rubyPsiInterpreter.interpret((PsiElement)container, null);
    }

    protected abstract void clearExceptions();

    protected abstract boolean uncountable(String var1);

    protected abstract void plural(RPsiElement var1, RPsiElement var2);

    protected abstract void singular(RPsiElement var1, RPsiElement var2);

    protected abstract void irregular(RPsiElement var1, RPsiElement var2);

    static {
        f = la.a(-4916316758023211973L, -1294661306693567570L, MethodHandles.lookup().lookupClass()).a(99356643050121L);
        long l2 = f ^ 0x39B14CF6EEE8L;
        INFLECTIONS_CHANGED = Topic.create((String)"InflectionsChanged", Runnable.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x712EBE508ABFL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/InflectorService";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadInflectionExceptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class InflectorCallable
    implements PsiCallable {
        private static final long a = la.a(4353107824334855996L, 7099458169502346728L, MethodHandles.lookup().lookupClass()).a(7287506886269L);

        private InflectorCallable() {
        }

        @Override
        public void processCall(RCallArguments arguments) {
            RPsiElement rPsiElement;
            List<RPsiElement> list2;
            long l2 = a ^ 0x498B3368CF58L;
            if (arguments.hasBlock() && Comparing.strEqual((String)InflectorService.c, (String)arguments.getCommand())) {
                arguments.interpretBlock(this);
                return;
            }
            String string = arguments.getCommand();
            if (Comparing.strEqual((String)InflectorService.b, (String)string)) {
                InflectorService.this.clearExceptions();
            }
            RPsiElement rPsiElement2 = (list2 = arguments.getArguments()).size() > 0 ? list2.get(0) : null;
            RPsiElement rPsiElement3 = rPsiElement = list2.size() > 1 ? list2.get(1) : null;
            if (rPsiElement2 == null) {
                return;
            }
            if (Comparing.strEqual((String)InflectorService.UNCOUNTABLE, (String)string)) {
                ArrayList arrayList = new ArrayList(2);
                for (Object object : list2) {
                    TextUtil.flattern(object, arrayList);
                }
                for (Object object : arrayList) {
                    if (StringUtil.isEmpty((String)object)) continue;
                    InflectorService.this.uncountable((String)object);
                }
                return;
            }
            if (rPsiElement == null) {
                return;
            }
            if (Comparing.strEqual((String)InflectorService.PLURAL, (String)string)) {
                InflectorService.this.plural(rPsiElement2, rPsiElement);
            } else if (Comparing.strEqual((String)InflectorService.SINGULAR, (String)string)) {
                InflectorService.this.singular(rPsiElement2, rPsiElement);
            } else if (Comparing.strEqual((String)InflectorService.IRREGULAR, (String)string)) {
                InflectorService.this.irregular(rPsiElement2, rPsiElement);
            }
        }
    }
}

