/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import b.h.la;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.filters.CompositeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GlobalCompilingVisitor {
    @NonNls
    private static final String h = "\\b(__\\$_\\w+)\\b";
    private static final Pattern i;
    private static final Set<String> a;
    private static final Pattern g;
    @NonNls
    private static final String c = ".*?\\b(.+?)\\b.*?";
    static final Pattern ourWordSearchPattern;
    private CompileContext e;
    private final List<PsiElement> b = new SmartList();
    private int d;
    private static final NodeFilter f;
    private static final long j;

    public static NodeFilter getFilter() {
        return f;
    }

    public void setHandler(PsiElement element, MatchingHandler handler) {
        MatchingHandler matchingHandler = this.e.getPattern().getHandlerSimple(element);
        if (matchingHandler instanceof SubstitutionHandler) {
            ((SubstitutionHandler)matchingHandler).setMatchHandler(handler);
        } else {
            this.e.getPattern().setHandler(element, handler);
        }
    }

    public final void handle(PsiElement element) {
        if ((!f.accepts(element) || StructuralSearchUtil.isIdentifier(element)) && this.e.getPattern().isRealTypedVar(element) && this.e.getPattern().getHandlerSimple(element) == null) {
            String string = this.e.getPattern().getTypedVarString(element);
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)this.e.getPattern().getHandler(string);
            if (substitutionHandler == null) {
                return;
            }
            this.e.getPattern().setHandler(element, substitutionHandler);
            if (this.e.getOptions().getVariableConstraint(substitutionHandler.getName()).isPartOfSearchResults()) {
                substitutionHandler.setTarget(true);
                this.e.getPattern().setTargetNode(element);
            }
        }
    }

    public CompileContext getContext() {
        return this.e;
    }

    public int getCodeBlockLevel() {
        return this.d;
    }

    public void setCodeBlockLevel(int codeBlockLevel) {
        this.d = codeBlockLevel;
    }

    public static void setFilter(MatchingHandler handler, NodeFilter filter) {
        if (handler.getFilter() != null && handler.getFilter().getClass() != filter.getClass()) {
            handler.setFilter(new CompositeFilter(filter, handler.getFilter()));
        } else {
            handler.setFilter(filter);
        }
    }

    public void setFilterSimple(PsiElement element, NodeFilter filter) {
        this.e.getPattern().getHandler(element).setFilter(filter);
    }

    public List<PsiElement> getLexicalNodes() {
        return this.b;
    }

    public void addLexicalNode(PsiElement node) {
        this.b.add(node);
    }

    void compile(PsiElement[] elements, CompileContext context) {
        this.d = 0;
        this.e = context;
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType());
        assert (structuralSearchProfile != null);
        structuralSearchProfile.compile(elements, this);
        assert (context.getPattern().getStrategy() != null);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind) {
        return this.processPatternStringWithFragments(pattern, kind, i);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind, Pattern substitutionPattern) {
        String string;
        String string2;
        long l2 = j ^ 0x46EEFDB989E7L;
        if (kind == OccurenceKind.LITERAL) {
            string2 = pattern.substring(1, pattern.length() - 1);
        } else if (kind == OccurenceKind.COMMENT) {
            string2 = pattern;
        } else {
            assert (false);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        Matcher matcher = substitutionPattern.matcher(string2);
        SmartList smartList = new SmartList();
        int n2 = 0;
        boolean bl2 = false;
        MatchingHandler matchingHandler = null;
        while (matcher.find()) {
            string = string2.substring(n2, matcher.start());
            if (!string.isEmpty()) {
                stringBuilder.append(StructuralSearchUtil.shieldRegExpMetaChars(string));
                bl2 = true;
                this.processTokenizedName(string, false, kind);
            }
            if ((matchingHandler = (SubstitutionHandler)this.getContext().getPattern().getHandler(matcher.group(1))) == null) {
                throw new MalformedPatternException();
            }
            smartList.add(matchingHandler);
            RegExpPredicate regExpPredicate = ((SubstitutionHandler)matchingHandler).findRegExpPredicate();
            if (regExpPredicate == null || !regExpPredicate.isWholeWords()) {
                stringBuilder.append("(.*?)");
            } else {
                stringBuilder.append(".*?\\b(").append(regExpPredicate.getRegExp()).append(")\\b.*?");
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(regExpPredicate, (SubstitutionHandler)matchingHandler)) {
                this.processTokenizedName(regExpPredicate.getRegExp(), false, kind);
            }
            n2 = matcher.end();
        }
        string = string2.substring(n2);
        if (!string.isEmpty()) {
            bl2 = true;
            stringBuilder.append(StructuralSearchUtil.shieldRegExpMetaChars(string));
            this.processTokenizedName(string, false, kind);
        }
        if (bl2) {
            if (kind == OccurenceKind.LITERAL) {
                stringBuilder.insert(0, "[\"']");
                stringBuilder.append("[\"']");
            }
            stringBuilder.append("$");
        }
        if (!smartList.isEmpty()) {
            return bl2 ? new LiteralWithSubstitutionHandler(stringBuilder.toString(), (List<? extends SubstitutionHandler>)smartList) : matchingHandler;
        }
        return null;
    }

    @Contract(value="null,_ -> false")
    static boolean isSuitablePredicate(RegExpPredicate predicate, SubstitutionHandler handler) {
        return predicate != null && handler.getMinOccurs() != 0 && predicate.couldBeOptimized();
    }

    public static void addFilesToSearchForGivenWord(String word, boolean endTransaction, OccurenceKind kind, CompileContext compileContext) {
        if (!compileContext.getSearchHelper().doOptimizing()) {
            return;
        }
        if (a.contains(word)) {
            return;
        }
        if (kind == OccurenceKind.CODE) {
            compileContext.getSearchHelper().addWordToSearchInCode(word);
        } else if (kind == OccurenceKind.COMMENT) {
            compileContext.getSearchHelper().addWordToSearchInComments(word);
        } else if (kind == OccurenceKind.LITERAL) {
            compileContext.getSearchHelper().addWordToSearchInLiterals(word);
        } else if (kind == OccurenceKind.TEXT) {
            compileContext.getSearchHelper().addWordToSearchInText(word);
        }
        if (endTransaction) {
            compileContext.getSearchHelper().endTransaction();
        }
    }

    public void processTokenizedName(String name, boolean skipComments, OccurenceKind kind) {
        long l2 = j ^ 0x6315EB2B1756L;
        WordTokenizer wordTokenizer = new WordTokenizer(name);
        Iterator<String> iterator = wordTokenizer.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (skipComments && (string.equals("/*") || string.equals("/**") || string.equals("*/") || string.equals("*") || string.equals("//"))) continue;
            Matcher matcher = g.matcher(string);
            if (matcher.matches()) {
                StringTokenizer stringTokenizer = new StringTokenizer(matcher.group(1), "|");
                while (stringTokenizer.hasMoreTokens()) {
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord(stringTokenizer.nextToken(), !stringTokenizer.hasMoreTokens(), kind, this.getContext());
                }
                continue;
            }
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(string, true, kind, this.getContext());
        }
    }

    static {
        j = la.a(-449893087272205586L, -6180274526547460529L, MethodHandles.lookup().lookupClass()).a(160352742612037L);
        long l2 = j ^ 0x1254A42959F0L;
        i = Pattern.compile(h);
        a = new HashSet<String>(Arrays.asList("Modifier", "Instance"));
        for (StructuralSearchProfile structuralSearchProfile : StructuralSearchProfile.EP_NAME.getExtensionList()) {
            a.addAll(structuralSearchProfile.getReservedWords());
        }
        g = Pattern.compile("^\\((.+)\\)$");
        ourWordSearchPattern = Pattern.compile(c);
        f = LexicalNodesFilter.getInstance();
    }

    private static class WordTokenizer {
        private final List<String> a = new SmartList();

        WordTokenizer(String text) {
            StringTokenizer stringTokenizer = new StringTokenizer(text);
            Matcher matcher = null;
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string = stringTokenizer.nextToken();
                if (matcher == null) {
                    matcher = ourWordSearchPattern.matcher(string);
                } else {
                    matcher.reset(string);
                }
                string = matcher.matches() ? matcher.group(1) : string;
                int n3 = 0;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    if (Character.isJavaIdentifierStart(string.charAt(n2))) continue;
                    if (n2 != n3) {
                        this.a.add(string.substring(n3, n2));
                    }
                    n3 = n2 + 1;
                }
                if (n2 == n3) continue;
                this.a.add(string.substring(n3, n2));
            }
        }

        Iterator<String> iterator() {
            return this.a.iterator();
        }
    }

    public static final class OccurenceKind
    extends Enum<OccurenceKind> {
        public static final /* enum */ OccurenceKind LITERAL;
        public static final /* enum */ OccurenceKind COMMENT;
        public static final /* enum */ OccurenceKind CODE;
        public static final /* enum */ OccurenceKind TEXT;
        private static final /* synthetic */ OccurenceKind[] a;

        public static OccurenceKind[] values() {
            return (OccurenceKind[])a.clone();
        }

        public static OccurenceKind valueOf(String name) {
            return Enum.valueOf(OccurenceKind.class, name);
        }

        static {
            long l2 = la.a(2862834814385590191L, -8685121646175322849L, MethodHandles.lookup().lookupClass()).a(255688575036054L) ^ 0x3EB02CC802B3L;
            LITERAL = new OccurenceKind();
            COMMENT = new OccurenceKind();
            CODE = new OccurenceKind();
            TEXT = new OccurenceKind();
            a = new OccurenceKind[]{LITERAL, COMMENT, CODE, TEXT};
        }
    }
}

