/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProfilingUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StartProfileCommand
extends AbstractCommand {
    public static final String PREFIX = "%startProfile";
    private final Project myProject;

    public StartProfileCommand(@NotNull String text, int line, Project project) {
        if (text == null) {
            StartProfileCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myProject = project;
    }

    public void startProfiling(String activityName, @NotNull List<String> commandParameters) throws RuntimeException {
        if (commandParameters == null) {
            StartProfileCommand.$$$reportNull$$$0(1);
        }
        YourKitProfilerHandler.getInstance().startProfiling(activityName, commandParameters);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            StartProfileCommand.$$$reportNull$$$0(2);
        }
        ActionCallbackProfilerStopper myActionCallback = new ActionCallbackProfilerStopper(this.myProject);
        String myActivityName = this.getText().substring(PREFIX.length()).trim();
        if (StringUtil.isEmpty((String)myActivityName)) {
            myActionCallback.reject(MessagesBundle.message("command.start.error", new Object[0]));
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    if (!ApplicationManagerEx.getApplicationEx().isInternal()) {
                        this.startProfiling(myActivityName, new ArrayList<String>());
                        Waiter.checkCondition(() -> ProfilingUtil.isCPUProfiling()).await();
                    }
                    myActionCallback.setDone();
                }
                catch (Throwable e) {
                    myActionCallback.setRejected();
                }
            });
        }
        Promise promise = Promises.toPromise((ActionCallback)myActionCallback);
        if (promise == null) {
            StartProfileCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/StartProfileCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/StartProfileCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startProfiling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

