/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.WPUtil;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPContentConfigurationManager {
    private static final WPContentConfigurationManager INSTANCE = new WPContentConfigurationManager();
    @NonNls
    private static final String DIRECTORIES_CONFIGURABLE_NAME = "Directories";

    public static WPContentConfigurationManager getInstance() {
        return INSTANCE;
    }

    private WPContentConfigurationManager() {
    }

    public void refreshIncludePaths(WPDataService.State newState, Project project) {
        if (!project.isDefault() && newState.isEnabled() && !newState.isDoNotAskContentConfigAgain()) {
            VirtualFile wpFile = WPContentConfigurationManager.getWPFile(newState);
            if (wpFile == null) {
                return;
            }
            if (VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)wpFile, (boolean)false)) {
                return;
            }
            boolean isPluginInsideWP = VfsUtilCore.isAncestor((VirtualFile)wpFile, (VirtualFile)project.getBaseDir(), (boolean)false);
            if (isPluginInsideWP) {
                Module module;
                boolean isWPIncluded;
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length == 1 && !(isWPIncluded = WPContentConfigurationManager.isFileInsideModule(wpFile, module = modules[0]))) {
                    WPContentConfigurationManager.suggestToChangeContentRoots(wpFile, project, module);
                }
            } else {
                boolean isWPIncluded = WPContentConfigurationManager.isInIncludePath(wpFile, project);
                if (!isWPIncluded) {
                    WPContentConfigurationManager.suggestToAddToIncludePath(wpFile, project);
                }
            }
        }
    }

    private static void suggestToChangeContentRoots(@NotNull VirtualFile wpFile, @NotNull Project project, @NotNull Module module) {
        if (wpFile == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(0);
        }
        if (project == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(1);
        }
        if (module == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(2);
        }
        String message = WPBundle.message("wp.suggestion.content.roots", new Object[0]);
        Function<Notification, AnAction> fixAction = notification -> {
            if (module == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(14);
            }
            if (project == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(15);
            }
            if (wpFile == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(16);
            }
            return new DumbAwareAction("Fix", (Notification)notification, module, project, wpFile){
                final /* synthetic */ Notification val$notification;
                final /* synthetic */ Module val$module;
                final /* synthetic */ Project val$project;
                final /* synthetic */ VirtualFile val$wpFile;
                {
                    this.val$notification = notification;
                    this.val$module = module;
                    this.val$project = project;
                    this.val$wpFile = virtualFile;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.val$notification.expire();
                    ModuleRootModificationUtil.updateModel((Module)this.val$module, model -> {
                        if (this.val$project == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (this.val$wpFile == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        ContentEntry[] contentEntries = model.getContentEntries();
                        ContentEntry rootEntry = null;
                        for (ContentEntry entry : contentEntries) {
                            VirtualFile entryFile = entry.getFile();
                            if (entryFile == null || !VfsUtilCore.isAncestor((VirtualFile)entryFile, (VirtualFile)this.val$project.getBaseDir(), (boolean)false)) continue;
                            rootEntry = entry;
                            break;
                        }
                        if (rootEntry != null) {
                            VirtualFile rootEntryFile = rootEntry.getFile();
                            if (rootEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)rootEntryFile, (VirtualFile)this.val$wpFile, (boolean)false)) {
                                model.addContentEntry(this.val$wpFile);
                                model.removeContentEntry(rootEntry);
                            }
                        } else {
                            model.addContentEntry(this.val$wpFile);
                        }
                    });
                    if (PlatformUtils.isPhpStorm()) {
                        Runnable runnable = () -> {
                            if (this.val$project == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            ShowSettingsUtil.getInstance().showSettingsDialog(this.val$project, WPContentConfigurationManager.DIRECTORIES_CONFIGURABLE_NAME);
                        };
                        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "wpFile";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$actionPerformed$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$actionPerformed$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        };
        Function<Notification, AnAction> ignoreAction = notification -> {
            if (project == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(13);
            }
            return new DumbAwareAction("Ignore", (Notification)notification, project){
                final /* synthetic */ Notification val$notification;
                final /* synthetic */ Project val$project;
                {
                    this.val$notification = notification;
                    this.val$project = project;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.val$notification.expire();
                    WPDataService.getInstance(this.val$project).setDoNotAskContentConfigurationAgain(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$2", "actionPerformed"));
                }
            };
        };
        WPContentConfigurationManager.showPopup(project, message, fixAction, ignoreAction);
    }

    private static void suggestToAddToIncludePath(@NotNull VirtualFile wpFile, @NotNull Project project) {
        if (wpFile == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(4);
        }
        String message = WPBundle.message("wp.suggestion.include.paths", new Object[0]);
        Function<Notification, AnAction> fixAction = notification -> {
            if (project == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(11);
            }
            if (wpFile == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(12);
            }
            return new DumbAwareAction("Fix", (Notification)notification, project, wpFile){
                final /* synthetic */ Notification val$notification;
                final /* synthetic */ Project val$project;
                final /* synthetic */ VirtualFile val$wpFile;
                {
                    this.val$notification = notification;
                    this.val$project = project;
                    this.val$wpFile = virtualFile;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.val$notification.expire();
                    Runnable runnable = () -> {
                        if (this.val$project == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (this.val$wpFile == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        PhpIncludePathManager facade = PhpIncludePathManager.getInstance((Project)this.val$project);
                        List includePaths = facade.getIncludePath();
                        ArrayList<String> newIncludePaths = new ArrayList<String>(includePaths.size() + 1);
                        newIncludePaths.addAll(includePaths);
                        String path = this.val$wpFile.getPath();
                        newIncludePaths.add(path);
                        facade.setIncludePath(newIncludePaths);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.val$project == null) {
                                3.$$$reportNull$$$0(3);
                            }
                            if (this.val$project.isDisposed()) {
                                return;
                            }
                            PhpUiUtil.editConfigurable((Project)this.val$project, (Configurable)new PhpProjectConfigurable(this.val$project));
                        });
                    };
                    ApplicationManager.getApplication().runWriteAction(runnable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "wpFile";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$actionPerformed$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        };
        Function<Notification, AnAction> ignoreAction = notification -> {
            if (project == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(10);
            }
            return new DumbAwareAction("Ignore", (Notification)notification, project){
                final /* synthetic */ Notification val$notification;
                final /* synthetic */ Project val$project;
                {
                    this.val$notification = notification;
                    this.val$project = project;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.val$notification.expire();
                    WPDataService.getInstance(this.val$project).setDoNotAskContentConfigurationAgain(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$4", "actionPerformed"));
                }
            };
        };
        Function<Notification, AnAction> showSettingsAction = notification -> {
            if (project == null) {
                WPContentConfigurationManager.$$$reportNull$$$0(9);
            }
            return new DumbAwareAction("Show settings", (Notification)notification, project){
                final /* synthetic */ Notification val$notification;
                final /* synthetic */ Project val$project;
                {
                    this.val$notification = notification;
                    this.val$project = project;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    this.val$notification.expire();
                    PhpUiUtil.editConfigurable((Project)this.val$project, (Configurable)new PhpProjectConfigurable(this.val$project));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$5", "actionPerformed"));
                }
            };
        };
        WPContentConfigurationManager.showPopup(project, message, fixAction, ignoreAction, showSettingsAction);
    }

    private static boolean isInIncludePath(@NotNull VirtualFile fileToCheck, @NotNull Project project) {
        if (fileToCheck == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(5);
        }
        if (project == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(6);
        }
        List includePaths = PhpIncludePathManager.getInstance((Project)project).getRoots();
        for (VirtualFile file : includePaths) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)fileToCheck, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getWPFile(WPDataService.State state) {
        String path = state.getWPPath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && file.isDirectory() ? file : null;
    }

    private static boolean isFileInsideModule(@NotNull VirtualFile wpFile, @NotNull Module module) {
        VirtualFile[] contentRoots;
        if (wpFile == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(7);
        }
        if (module == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(8);
        }
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)wpFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static void showPopup(Project project, String message, Function<Notification, AnAction> ... actions) {
        Runnable runnable = () -> WPUtil.notifyGlobally(project, WPBundle.message("wp.plugin.title", new Object[0]), message, NotificationType.INFORMATION, actions);
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wpFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/init/WPContentConfigurationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToChangeContentRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToAddToIncludePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInIncludePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInsideModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToAddToIncludePath$4";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToAddToIncludePath$3";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToAddToIncludePath$2";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToChangeContentRoots$1";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToChangeContentRoots$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

