/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.browserConnection.BrowserConnector;
import com.intellij.javascript.debugger.browserConnection.BrowserQualifier;
import com.intellij.javascript.debugger.browserConnection.WebBrowserConnectorBundle;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.ChromeExtensionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ChromeConnector
extends BrowserConnector {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Browser Connection", NotificationDisplayType.STICKY_BALLOON, true);
    private final SingletonNotificationManager notification = new SingletonNotificationManager(NOTIFICATION_GROUP, NotificationType.INFORMATION, null);

    ChromeConnector() {
    }

    public boolean canHandle(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            ChromeConnector.$$$reportNull$$$0(0);
        }
        return !browserQualifier.equals((Object)BrowserQualifier.FIREFOX);
    }

    @NotNull
    public Promise<?> ensureExtensionInstalled(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            ChromeConnector.$$$reportNull$$$0(1);
        }
        if (ChromeExtensionUtil.isChromeRunning(browser)) {
            this.notification.notify(WebBrowserConnectorBundle.message((String)"chrome.extension.required.title", (Object[])new Object[]{browser.getName()}), WebBrowserConnectorBundle.message((String)"chrome.extension.required", (Object[])new Object[]{browser.getName()}), project, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(browser, project));
        }
        Promise promise2 = Promises.resolvedPromise();
        if (promise2 == null) {
            ChromeConnector.$$$reportNull$$$0(2);
        }
        return promise2;
    }

    public void checkVersion(@NotNull WebBrowser browser, @Nullable String version, @Nullable Project project) {
        if (browser == null) {
            ChromeConnector.$$$reportNull$$$0(3);
        }
        if (StringUtil.compareVersionNumbers((String)version, (String)"0.5") < 0) {
            this.notification.notify(WebBrowserConnectorBundle.message((String)"chrome.update.extension.title", (Object[])new Object[0]), WebBrowserConnectorBundle.message((String)"chrome.update.extension.0.4", (Object[])new Object[0]), project, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(browser, project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserQualifier";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/debugger/wip/ChromeConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/debugger/wip/ChromeConnector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExtensionInstalled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHandle";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ensureExtensionInstalled";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

