/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorsUtil {
    private GridCellEditorsUtil() {
    }

    public static boolean isBooleanCell(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel<DataConsumer.Row, DataConsumer.Column> model;
        DataConsumer.Column c2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(2);
        }
        if ((c2 = (model = grid.getDataModel(DataAccessType.DATABASE_DATA)).getColumn(column2)) == null || !ObjectFormatter.isBooleanColumn(c2)) {
            return false;
        }
        Object value = model.getValueAt(row, column2);
        return value == null || value == ReservedCellValue.NULL || ObjectFormatter.getBooleanValue(value) != null;
    }

    public static void showCellEditorPopup(final DataGrid grid, final Component component, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup popupActions = (ActionGroup)actionManager.getAction("Console.TableResult.CellEditor.Popup");
        JPopupMenu popup = actionManager.createActionPopupMenu("EditorPopup", popupActions).getComponent();
        popup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)component);
                fm.requestFocus((Component)grid.getPreferredFocusedComponent(), true);
            }
        });
        popup.show(component, x, y);
    }

    @Nullable
    public static TextCompletionProvider createCompletionProvider(final @NotNull DataGrid grid, final @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel model;
        DataConsumer.Column c2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(3);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(4);
        }
        if (!GridCellEditorsUtil.canComplete(c2 = (model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column2))) {
            return null;
        }
        return new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List items = GridCellEditorsUtil.getPossibleValues(grid, column2);
                if (!items.isEmpty()) {
                    List list = items;
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List rows = model.getRows();
                HashSet objects = ContainerUtil.newHashSet((int)rows.size());
                Dbms dbms = DataGridUtil.getDbms(grid);
                for (DataConsumer.Row r : rows) {
                    Object v = c2.getValue(r);
                    if (v == null) continue;
                    objects.add(grid.getObjectFormatter().getPlainValue(c2, r, dbms));
                }
                HashSet hashSet = objects;
                if (hashSet == null) {
                    2.$$$reportNull$$$0(1);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$2", "getItems"));
            }
        };
    }

    private static boolean canComplete(@Nullable DataConsumer.Column c2) {
        return c2 != null && !DbImplUtil.canInsertBlob(c2) && (JdbcUtil.isNumberType((int)c2.type) || !c2.clazz.equals("java.lang.Integer") || JdbcUtil.isStringType((int)c2.type));
    }

    @NotNull
    private static List<String> getPossibleValues(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        ModelHelper modelHelper;
        DataType dataType;
        List values2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(5);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(6);
        }
        List list = values2 = (dataType = (modelHelper = DbImplUtil.getModelHelper(DataGridUtil.getDbms(grid))).getDataTypeForGridCompletion(grid, column2)) != null ? dataType.enumValues : null;
        List list2 = values2 != null ? ContainerUtil.map((Collection)values2, modelHelper::unquoteEnumValue) : ContainerUtil.emptyList();
        if (list2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanCell";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleValues";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

