/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JSInterfaceMemberDependencyGraph
implements MemberDependencyGraph<JSAttributeListOwner, JSMemberInfo> {
    protected HashSet<JSAttributeListOwner> myInterfaceDependencies = null;
    protected HashMap<JSElement, HashSet<JSClass>> myMembersToInterfacesMap = new HashMap();
    protected HashSet<JSClass> myImplementedInterfaces;
    protected HashMap<JSClass, HashSet<JSAttributeListOwner>> myMethodsFromInterfaces;
    protected JSClass myClass;

    public JSInterfaceMemberDependencyGraph(JSClass aClass) {
        this.myClass = aClass;
        this.myImplementedInterfaces = new HashSet();
        this.myMethodsFromInterfaces = new HashMap();
    }

    public void memberChanged(JSMemberInfo memberInfo) {
        if (memberInfo.getMember() instanceof JSClass) {
            JSClass aClass = (JSClass)memberInfo.getMember();
            this.myInterfaceDependencies = null;
            this.myMembersToInterfacesMap = null;
            if (memberInfo.isChecked()) {
                this.myImplementedInterfaces.add(aClass);
            } else {
                this.myImplementedInterfaces.remove(aClass);
            }
        }
    }

    public Set<? extends JSAttributeListOwner> getDependent() {
        if (this.myInterfaceDependencies == null) {
            this.myInterfaceDependencies = new HashSet();
            this.myMembersToInterfacesMap = new HashMap();
            for (JSClass implementedInterface : this.myImplementedInterfaces) {
                this.addInterfaceDeps(implementedInterface);
            }
        }
        return this.myInterfaceDependencies;
    }

    public Set<? extends JSAttributeListOwner> getDependenciesOf(JSAttributeListOwner member) {
        Set<? extends JSAttributeListOwner> dependent = this.getDependent();
        if (dependent.contains(member)) {
            return this.myMembersToInterfacesMap.get(member);
        }
        return null;
    }

    public String getElementTooltip(JSAttributeListOwner member) {
        Set<? extends JSAttributeListOwner> dependencies = this.getDependenciesOf(member);
        if (dependencies == null || dependencies.size() == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(RefactoringBundle.message((String)"interface.member.dependency.required.by.interfaces", (Object[])new Object[]{dependencies.size()}));
        buffer.append(" ");
        Iterator<? extends JSAttributeListOwner> iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            JSClass aClass = (JSClass)iterator.next();
            buffer.append(aClass.getName());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    protected void addInterfaceDeps(JSClass intf) {
        HashSet<Object> interfaceMethods = this.myMethodsFromInterfaces.get(intf);
        if (interfaceMethods == null) {
            interfaceMethods = new HashSet();
            this.buildInterfaceMethods(interfaceMethods, intf);
            this.myMethodsFromInterfaces.put(intf, interfaceMethods);
        }
        for (JSElement jSElement : interfaceMethods) {
            HashSet<Object> interfaces = this.myMembersToInterfacesMap.get(jSElement);
            if (interfaces == null) {
                interfaces = new HashSet();
                this.myMembersToInterfacesMap.put(jSElement, interfaces);
            }
            interfaces.add(intf);
        }
        this.myInterfaceDependencies.addAll(interfaceMethods);
    }

    private void buildInterfaceMethods(HashSet<JSAttributeListOwner> interfaceMethods, JSClass intf) {
        JSReferenceList extendsList;
        for (JSFunction method1 : intf.getFunctions()) {
            JSFunction method = this.myClass.findFunctionByName(method1.getName());
            if (method == null) continue;
            interfaceMethods.add((JSAttributeListOwner)method);
        }
        JSReferenceList implementsList = intf.getImplementsList();
        if (implementsList != null) {
            for (JSClass aImplemented : implementsList.getReferencedClasses()) {
                this.buildInterfaceMethods(interfaceMethods, aImplemented);
            }
        }
        if ((extendsList = intf.getExtendsList()) != null) {
            for (JSClass aExtended : extendsList.getReferencedClasses()) {
                this.buildInterfaceMethods(interfaceMethods, aExtended);
            }
        }
    }
}

