/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.types.JSElementWithSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSClassHierarchyVisitor {
    public static final int DEFAULT_DEPTH_LIMIT = 30;
    @NotNull
    private final JSClassUtils.JSClassHierarchyProcessor myProcessor;
    @NotNull
    private final Condition<? super JSClass> myClassToVisitAcceptor;
    @NotNull
    private final Set<Object> myVisited;
    private final int myDepthLimit;
    private final boolean myIncludeInterfaces;

    JSClassHierarchyVisitor(boolean includeInterfaces, @NotNull JSClassUtils.JSClassHierarchyProcessor processor, @NotNull Condition<? super JSClass> classToVisitAcceptor, int depthLimit) {
        if (processor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(0);
        }
        if (classToVisitAcceptor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(1);
        }
        this.myVisited = ContainerUtil.newHashSet();
        this.myIncludeInterfaces = includeInterfaces;
        this.myProcessor = processor;
        this.myClassToVisitAcceptor = classToVisitAcceptor;
        this.myDepthLimit = depthLimit;
    }

    boolean visit(@NotNull JSClass<?> clazz, @NotNull JSTypeSubstitutor typeSubstitutor) {
        if (clazz == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(2);
        }
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(3);
        }
        return this.visit(clazz, typeSubstitutor, null, false, 0);
    }

    private boolean visit(@NotNull JSClass<?> clazz, @NotNull JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, boolean staticContext, int depth) {
        if (clazz == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(4);
        }
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(5);
        }
        if (!this.myVisited.add(staticContext ? Pair.create(clazz, (Object)true) : clazz)) {
            return true;
        }
        if (!this.myProcessor.process((JSClass<?>)clazz, typeSubstitutor, fromImplements != null && fromImplements != false, staticContext, depth)) {
            return false;
        }
        if (depth == this.myDepthLimit) {
            return true;
        }
        if (clazz instanceof TypeScriptEnum) {
            return this.processEnumSuperClassesInHierarchy((TypeScriptEnum)clazz, typeSubstitutor, fromImplements, staticContext, depth);
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = clazz.getExtendsList();
        JSReferenceList implementsList = this.myIncludeInterfaces ? clazz.getImplementsList() : null;
        HashSet interfacesExtendedViaVariables = ContainerUtil.newHashSet();
        int extendsListElementsLeft = 0;
        if (extendsList != null) {
            Object[] extendsListResolvedExpressions = extendsList.getMembers();
            interfacesExtendedViaVariables.addAll((Collection)((StreamEx)StreamEx.of((Object[])extendsListResolvedExpressions).map(p -> p.getClasses()).flatMap(p -> p.stream()).filter(p -> p.isInterface())).collect(Collectors.toSet()));
            ContainerUtil.addAll((Collection)superReferences, (Object[])extendsListResolvedExpressions);
            extendsListElementsLeft = superReferences.size();
        }
        if (implementsList != null) {
            ContainerUtil.addAll((Collection)superReferences, (Object[])implementsList.getMembers());
        }
        for (JSReferenceListMember superReference : superReferences) {
            boolean currentFromImplements = fromImplements == null ? extendsListElementsLeft-- <= 0 : fromImplements;
            Collection classesWithSubstitutors = superReference.getClassesWithSubstitutors();
            for (JSElementWithSubstitutor superClassWithSubstitutor : classesWithSubstitutors) {
                JSClass superClass = (JSClass)superClassWithSubstitutor.myElement;
                JSTypeSubstitutor superSubstitutor = superClassWithSubstitutor.myTypeSubstitutor;
                boolean newStaticContext = superClassWithSubstitutor.isStaticContext() || staticContext;
                JSTypeSubstitutor combinedSubstitutor = JSClassUtils.combineSuperClassSubstitutor(typeSubstitutor, superSubstitutor);
                if (this.myIncludeInterfaces && superClass instanceof TypeScriptTypeAlias) {
                    ArrayList<JSClass> aliasResolves = new ArrayList<JSClass>();
                    TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)superClass, aliasResolves, null);
                    for (JSClass aliasResolve : aliasResolves) {
                        if (!this.myClassToVisitAcceptor.value((Object)aliasResolve) || !JSClassHierarchyVisitor.canInclude(this.myIncludeInterfaces, aliasResolve, interfacesExtendedViaVariables) || this.visit(aliasResolve, combinedSubstitutor, currentFromImplements, newStaticContext, depth + 1)) continue;
                        return false;
                    }
                    continue;
                }
                if (!this.myClassToVisitAcceptor.value((Object)superClass) || !JSClassHierarchyVisitor.canInclude(this.myIncludeInterfaces, superClass, interfacesExtendedViaVariables) || this.visit(superClass, combinedSubstitutor, currentFromImplements, newStaticContext, depth + 1)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canInclude(boolean includeInterfaces, @NotNull JSClass superClass, Set<JSClass> interfacesExtendedViaVariables) {
        if (superClass == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(6);
        }
        if ("Object".equals(superClass.getName())) {
            return false;
        }
        if (includeInterfaces) {
            return true;
        }
        boolean isInterfaceLike = superClass instanceof TypeScriptInterface || superClass instanceof TypeScriptTypeAlias;
        return !isInterfaceLike || interfacesExtendedViaVariables != null && interfacesExtendedViaVariables.contains(superClass);
    }

    private boolean processEnumSuperClassesInHierarchy(@NotNull TypeScriptEnum clazz, @NotNull JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, boolean staticContext, int depth) {
        if (clazz == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(7);
        }
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(8);
        }
        for (JSClass aClass : clazz.getSupers()) {
            if (!this.myClassToVisitAcceptor.value((Object)aClass) || !JSClassHierarchyVisitor.canInclude(this.myIncludeInterfaces, aClass, null) || this.visit(aClass, typeSubstitutor, fromImplements, staticContext, depth + 1)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToVisitAcceptor";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSClassHierarchyVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canInclude";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processEnumSuperClassesInHierarchy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

