/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementPolicy;
import org.owasp.html.FilterUrlByProtocolAttributePolicy;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.PolicyFactory;
import org.owasp.html.StandardUrlAttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.StylingPolicy;
import org.owasp.html.TCB;
import org.owasp.html.TagBalancingHtmlStreamEventReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
@NotThreadSafe
public class HtmlPolicyBuilder {
    public static final ImmutableSet<String> DEFAULT_SKIP_IF_EMPTY = ImmutableSet.of((Object)"a", (Object)"font", (Object)"img", (Object)"input", (Object)"span");
    private final Map<String, ElementPolicy> elPolicies = Maps.newLinkedHashMap();
    private final Map<String, Map<String, AttributePolicy>> attrPolicies = Maps.newLinkedHashMap();
    private final Map<String, AttributePolicy> globalAttrPolicies = Maps.newLinkedHashMap();
    private final Set<String> allowedProtocols = Sets.newLinkedHashSet();
    private final Set<String> skipIfEmpty = Sets.newLinkedHashSet(DEFAULT_SKIP_IF_EMPTY);
    private final Map<String, Boolean> textContainers = Maps.newLinkedHashMap();
    private boolean requireRelNofollowOnLinks;
    private static final Set<String> URL_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"action", (Object)"archive", (Object)"background", (Object)"cite", (Object)"classid", (Object)"codebase", (Object[])new String[]{"data", "dsync", "formaction", "href", "icon", "longdesc", "manifest", "poster", "profile", "src", "srcset", "usemap"});
    private transient ImmutableMap<String, ElementAndAttributePolicies> compiledPolicies;

    public HtmlPolicyBuilder allowElements(String ... elementNames) {
        return this.allowElements(ElementPolicy.IDENTITY_ELEMENT_POLICY, elementNames);
    }

    public HtmlPolicyBuilder disallowElements(String ... elementNames) {
        return this.allowElements(ElementPolicy.REJECT_ALL_ELEMENT_POLICY, elementNames);
    }

    public HtmlPolicyBuilder allowElements(ElementPolicy policy, String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            ElementPolicy newPolicy = ElementPolicy.Util.join(this.elPolicies.get(elementName), policy);
            this.elPolicies.put(elementName, newPolicy);
            if (this.textContainers.containsKey(elementName) || !TagBalancingHtmlStreamEventReceiver.allowsPlainTextualContent(elementName)) continue;
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder allowCommonInlineFormattingElements() {
        return this.allowElements("b", "i", "font", "s", "u", "o", "sup", "sub", "ins", "del", "strong", "strike", "tt", "code", "big", "small", "br", "span", "em");
    }

    public HtmlPolicyBuilder allowCommonBlockElements() {
        return this.allowElements("p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote");
    }

    public HtmlPolicyBuilder allowTextIn(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowTextIn(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.textContainers.put(elementName, false);
        }
        return this;
    }

    public HtmlPolicyBuilder allowWithoutAttributes(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.skipIfEmpty.remove(elementName);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowWithoutAttributes(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.skipIfEmpty.add(elementName);
        }
        return this;
    }

    public AttributeBuilder allowAttributes(String ... attributeNames) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String attributeName : attributeNames) {
            b.add((Object)HtmlLexer.canonicalName(attributeName));
        }
        return new AttributeBuilder((List<? extends String>)b.build());
    }

    public AttributeBuilder disallowAttributes(String ... attributeNames) {
        return this.allowAttributes(attributeNames).matching(AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY);
    }

    private HtmlPolicyBuilder allowAttributesGlobally(AttributePolicy policy, List<String> attributeNames) {
        this.invalidateCompiledState();
        for (String attributeName : attributeNames) {
            AttributePolicy oldPolicy = this.globalAttrPolicies.get(attributeName);
            this.globalAttrPolicies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
        }
        return this;
    }

    private HtmlPolicyBuilder allowAttributesOnElements(AttributePolicy policy, List<String> attributeNames, List<String> elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            LinkedHashMap policies = this.attrPolicies.get(elementName);
            if (policies == null) {
                policies = Maps.newLinkedHashMap();
                this.attrPolicies.put(elementName, policies);
            }
            for (String attributeName : attributeNames) {
                AttributePolicy oldPolicy = (AttributePolicy)policies.get(attributeName);
                policies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
            }
        }
        return this;
    }

    public HtmlPolicyBuilder requireRelNofollowOnLinks() {
        this.invalidateCompiledState();
        this.requireRelNofollowOnLinks = true;
        return this;
    }

    public HtmlPolicyBuilder allowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.add(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.remove(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder allowStandardUrlProtocols() {
        return this.allowUrlProtocols("http", "https", "mailto");
    }

    public HtmlPolicyBuilder allowStyling() {
        this.allowStyling(CssSchema.DEFAULT);
        return this;
    }

    public HtmlPolicyBuilder allowStyling(CssSchema whitelist) {
        this.invalidateCompiledState();
        this.allowAttributesGlobally(new StylingPolicy(whitelist), (List<String>)ImmutableList.of((Object)"style"));
        return this;
    }

    public HtmlSanitizer.Policy build(HtmlStreamEventReceiver out) {
        return this.toFactory().apply(out);
    }

    public <CTX> HtmlSanitizer.Policy build(HtmlStreamEventReceiver out, @Nullable HtmlChangeListener<? super CTX> listener, @Nullable CTX context) {
        return this.toFactory().apply(out, listener, context);
    }

    public PolicyFactory toFactory() {
        ImmutableSet.Builder textContainerSet = ImmutableSet.builder();
        for (Map.Entry<String, Boolean> textContainer : this.textContainers.entrySet()) {
            if (!Boolean.TRUE.equals(textContainer.getValue())) continue;
            textContainerSet.add((Object)textContainer.getKey());
        }
        return new PolicyFactory(this.compilePolicies(), (ImmutableSet<String>)textContainerSet.build(), (ImmutableMap<String, AttributePolicy>)ImmutableMap.copyOf(this.globalAttrPolicies));
    }

    private void invalidateCompiledState() {
        this.compiledPolicies = null;
    }

    private ImmutableMap<String, ElementAndAttributePolicies> compilePolicies() {
        if (this.compiledPolicies != null) {
            return this.compiledPolicies;
        }
        LinkedHashMap elPolicies = Maps.newLinkedHashMap(this.elPolicies);
        LinkedHashMap attrPolicies = Maps.newLinkedHashMap(this.attrPolicies);
        for (Map.Entry entry : attrPolicies.entrySet()) {
            entry.setValue(Maps.newLinkedHashMap((Map)((Map)entry.getValue())));
        }
        LinkedHashMap globalAttrPolicies = Maps.newLinkedHashMap(this.globalAttrPolicies);
        ImmutableSet immutableSet = ImmutableSet.copyOf(this.allowedProtocols);
        if (this.requireRelNofollowOnLinks) {
            ElementPolicy linkPolicy = (ElementPolicy)elPolicies.get("a");
            if (linkPolicy == null) {
                linkPolicy = ElementPolicy.REJECT_ALL_ELEMENT_POLICY;
            }
            elPolicies.put("a", ElementPolicy.Util.join(linkPolicy, RelNofollowPolicy.INSTANCE));
        }
        AttributePolicy urlAttributePolicy = immutableSet.size() == 3 && immutableSet.contains("mailto") && immutableSet.contains("http") && immutableSet.contains("https") ? StandardUrlAttributePolicy.INSTANCE : new FilterUrlByProtocolAttributePolicy((Iterable<? extends String>)immutableSet);
        LinkedHashSet toGuard = Sets.newLinkedHashSet(URL_ATTRIBUTE_NAMES);
        for (String string : URL_ATTRIBUTE_NAMES) {
            if (!globalAttrPolicies.containsKey(string)) continue;
            toGuard.remove(string);
            globalAttrPolicies.put(string, AttributePolicy.Util.join(urlAttributePolicy, (AttributePolicy)globalAttrPolicies.get(string)));
        }
        for (Map.Entry entry : attrPolicies.entrySet()) {
            Map policies = (Map)entry.getValue();
            for (String urlAttributeName : toGuard) {
                if (!policies.containsKey(urlAttributeName)) continue;
                policies.put(urlAttributeName, AttributePolicy.Util.join(urlAttributePolicy, (AttributePolicy)policies.get(urlAttributeName)));
            }
        }
        ImmutableMap.Builder policiesBuilder = ImmutableMap.builder();
        for (Map.Entry e : elPolicies.entrySet()) {
            AttributePolicy policy;
            String attributeName;
            String string = (String)e.getKey();
            ElementPolicy elPolicy = (ElementPolicy)e.getValue();
            if (ElementPolicy.REJECT_ALL_ELEMENT_POLICY.equals(elPolicy)) continue;
            Map elAttrPolicies = (Map)attrPolicies.get(string);
            if (elAttrPolicies == null) {
                elAttrPolicies = ImmutableMap.of();
            }
            ImmutableMap.Builder attrs = ImmutableMap.builder();
            for (Map.Entry ape : elAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                if (globalAttrPolicies.containsKey(attributeName) || AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy = (AttributePolicy)ape.getValue())) continue;
                attrs.put((Object)attributeName, (Object)policy);
            }
            for (Map.Entry ape : globalAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                policy = AttributePolicy.Util.join((AttributePolicy)elAttrPolicies.get(attributeName), (AttributePolicy)ape.getValue());
                if (AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy)) continue;
                attrs.put((Object)attributeName, (Object)policy);
            }
            policiesBuilder.put((Object)string, (Object)new ElementAndAttributePolicies(string, elPolicy, (Map<? extends String, ? extends AttributePolicy>)attrs.build(), this.skipIfEmpty.contains(string)));
        }
        this.compiledPolicies = policiesBuilder.build();
        return this.compiledPolicies;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RelNofollowPolicy
    implements ElementPolicy {
        static final RelNofollowPolicy INSTANCE = new RelNofollowPolicy();

        private RelNofollowPolicy() {
        }

        @Override
        public String apply(String elementName, List<String> attrs) {
            int n = attrs.size();
            for (int i = 0; i < n; i += 2) {
                if (!"href".equals(attrs.get(i))) continue;
                attrs.add("rel");
                attrs.add("nofollow");
                break;
            }
            return elementName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AttributeBuilder {
        private final List<String> attributeNames;
        private AttributePolicy policy = AttributePolicy.IDENTITY_ATTRIBUTE_POLICY;

        AttributeBuilder(List<? extends String> attributeNames) {
            this.attributeNames = ImmutableList.copyOf(attributeNames);
        }

        public AttributeBuilder matching(AttributePolicy attrPolicy) {
            this.policy = AttributePolicy.Util.join(this.policy, attrPolicy);
            return this;
        }

        public AttributeBuilder matching(final Pattern pattern) {
            return this.matching(new AttributePolicy(){

                @Nullable
                public String apply(String elementName, String attributeName, String value) {
                    return pattern.matcher(value).matches() ? value : null;
                }
            });
        }

        public AttributeBuilder matching(final Predicate<? super String> filter) {
            return this.matching(new AttributePolicy(){

                @Nullable
                public String apply(String elementName, String attributeName, String value) {
                    return filter.apply((Object)value) ? value : null;
                }
            });
        }

        public AttributeBuilder matching(boolean ignoreCase, String ... allowedValues) {
            return this.matching(ignoreCase, (Set<? extends String>)ImmutableSet.copyOf((Object[])allowedValues));
        }

        public AttributeBuilder matching(final boolean ignoreCase, Set<? extends String> allowedValues) {
            final ImmutableSet allowed = ImmutableSet.copyOf(allowedValues);
            return this.matching(new AttributePolicy(){

                @Nullable
                public String apply(String elementName, String attributeName, String uncanonValue) {
                    String value = ignoreCase ? Strings.toLowerCase(uncanonValue) : uncanonValue;
                    return allowed.contains((Object)value) ? value : null;
                }
            });
        }

        public HtmlPolicyBuilder globally() {
            return HtmlPolicyBuilder.this.allowAttributesGlobally(this.policy, this.attributeNames);
        }

        public HtmlPolicyBuilder onElements(String ... elementNames) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (String elementName : elementNames) {
                b.add((Object)HtmlLexer.canonicalName(elementName));
            }
            return HtmlPolicyBuilder.this.allowAttributesOnElements(this.policy, this.attributeNames, (List)b.build());
        }
    }
}

