/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.StringHash;
import org.jetbrains.coverage.gnu.trove.TLongObjectHashMap;

public class StringsPool {
    private static final TLongObjectHashMap<String> myReusableStrings = new TLongObjectHashMap(30000);
    private static final String EMPTY = "";

    public static String getFromPool(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return EMPTY;
        }
        long hash = StringHash.calc(value);
        String reused = myReusableStrings.get(hash);
        if (reused != null) {
            return reused;
        }
        reused = new String(value);
        myReusableStrings.put(hash, reused);
        return reused;
    }
}

