/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CommitInfo;

public class DirectoryEntry
extends BaseNodeDescription
implements Comparable<DirectoryEntry> {
    public static final Comparator<DirectoryEntry> CASE_INSENSITIVE_ORDER = Comparator.comparing(DirectoryEntry::getKind).thenComparing(entry -> entry.getUrl().toDecodedString(), String.CASE_INSENSITIVE_ORDER);
    private final String myName;
    @NotNull
    private final CommitInfo myCommitInfo;
    private final String myPath;
    private final Url myUrl;
    private final Url myRepositoryRoot;

    public DirectoryEntry(Url url, Url repositoryRoot, String name, @NotNull NodeKind kind, @Nullable CommitInfo commitInfo, String path) {
        if (kind == null) {
            DirectoryEntry.$$$reportNull$$$0(0);
        }
        super(kind);
        this.myUrl = url;
        this.myRepositoryRoot = repositoryRoot;
        this.myName = name;
        this.myCommitInfo = (CommitInfo)ObjectUtils.notNull((Object)commitInfo, (Object)CommitInfo.EMPTY);
        this.myPath = path;
    }

    public Url getUrl() {
        return this.myUrl;
    }

    public Url getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            DirectoryEntry.$$$reportNull$$$0(1);
        }
        return nodeKind;
    }

    public Date getDate() {
        return this.myCommitInfo.getDate();
    }

    public long getRevision() {
        return this.myCommitInfo.getRevision();
    }

    public String getAuthor() {
        return this.myCommitInfo.getAuthor();
    }

    public String getRelativePath() {
        return this.myPath == null ? this.myName : this.myPath;
    }

    @Override
    public int compareTo(@NotNull DirectoryEntry o) {
        int result;
        if (o == null) {
            DirectoryEntry.$$$reportNull$$$0(2);
        }
        return (result = this.getKind().compareTo(o.getKind())) != 0 ? result : this.myUrl.toString().compareTo(o.getUrl().toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/browse/DirectoryEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/browse/DirectoryEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

