/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.vagrant.VagrantBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class AddVagrantBoxDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myName;
    private JTextField myUrl;
    private final Project myProject;
    @Nullable
    private final List<? extends VagrantBox> myVagrantBoxes;

    protected AddVagrantBoxDialog(@Nullable Project project, List<? extends VagrantBox> boxes) {
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Add Vagrant Box");
        this.myProject = project;
        this.myVagrantBoxes = boxes;
        if (this.myVagrantBoxes != null && this.myVagrantBoxes.size() == 0) {
            this.initByDefault();
        }
        this.init();
    }

    private void initByDefault() {
        this.myName.setText("lucid32");
        this.myUrl.setText("http://files.vagrantup.com/lucid32.box");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUrl;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.getName())) {
            return new ValidationInfo("Specify box name", (JComponent)this.myName);
        }
        if (this.myVagrantBoxes != null) {
            for (VagrantBox vagrantBox : this.myVagrantBoxes) {
                if (!this.getName().equals(vagrantBox.getName())) continue;
                return new ValidationInfo("The box with the name " + this.getName() + " already exists", (JComponent)this.myName);
            }
        }
        if (StringUtil.isEmpty((String)this.getUrl())) {
            return new ValidationInfo("Specify url for the box", (JComponent)this.myName);
        }
        return null;
    }

    public String getName() {
        return this.myName.getText().trim();
    }

    public String getUrl() {
        return this.myUrl.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 6, 3, new Dimension(400, -1), null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Box name");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Box URL");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myName = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUrl = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

