/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "convertToText", "", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    public static final void assertDirectoryContentMatches(@NotNull File file, @NotNull DirectoryContentSpecImpl spec, @NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        DirectoryContentSpecImpl directoryContentSpecImpl = spec;
        if (directoryContentSpecImpl instanceof DirectorySpec) {
            DirectoryContentSpecImplKt.assertDirectoryMatches(file, (DirectorySpecBase)spec, relativePath);
        } else if (directoryContentSpecImpl instanceof ZipSpec) {
            File file2 = FileUtil.createTempDirectory((String)("extracted-" + file.getName()), null, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirec\u2026file.name}\", null, false)");
            File dirForExtracted = file2;
            ZipUtil.extract((File)file, (File)dirForExtracted, null);
            DirectoryContentSpecImplKt.assertDirectoryMatches(dirForExtracted, (DirectorySpecBase)spec, relativePath);
            FileUtil.delete((File)dirForExtracted);
        } else if (directoryContentSpecImpl instanceof FileSpec) {
            Assert.assertTrue((String)(file + " is not a file"), (boolean)file.isFile());
            if (((FileSpec)spec).getContent() != null) {
                byte[] byArray = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"FileUtil.loadFileBytes(file)");
                byte[] actualBytes = byArray;
                if (!Arrays.equals(actualBytes, ((FileSpec)spec).getContent())) {
                    String place;
                    String actualString = DirectoryContentSpecImplKt.convertToText(actualBytes);
                    String expectedString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                    String string = place = Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "";
                    if (actualString != null && expectedString != null) {
                        Assert.assertEquals((String)("File content mismatch" + place + ':'), (Object)expectedString, (Object)actualString);
                    } else {
                        Assert.fail((String)("Binary file content mismatch" + place));
                    }
                }
            }
        }
    }

    private static final String convertToText(@NotNull byte[] $receiver) {
        Charset charset;
        CharsetToolkit.GuessedEncoding guessedEncoding = new CharsetToolkit($receiver, Charsets.UTF_8).guessFromContent($receiver.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)guessedEncoding, (String)"CharsetToolkit(this, Cha\u20268).guessFromContent(size)");
        CharsetToolkit.GuessedEncoding encoding = guessedEncoding;
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String($receiver, charset2);
    }

    private static final void assertDirectoryMatches(File file, DirectorySpecBase spec, String relativePath) {
        Assert.assertTrue((String)(file + " is not a directory"), (boolean)file.isDirectory());
        Object[] objectArray = file.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"file.list()");
        List actualChildrenNames = ArraysKt.sortedWith((Object[])objectArray, (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Map<String, DirectoryContentSpecImpl> children = spec.getChildren();
        List expectedChildrenNames = CollectionsKt.sortedWith((Iterable)children.keySet(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + (Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)expectedChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)actualChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Iterable $receiver$iv = actualChildrenNames;
        for (Object element$iv : $receiver$iv) {
            String child = (String)element$iv;
            File file2 = new File(file, child);
            DirectoryContentSpecImpl directoryContentSpecImpl = children.get(child);
            if (directoryContentSpecImpl == null) {
                Intrinsics.throwNpe();
            }
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(file2, directoryContentSpecImpl, relativePath + '/' + child);
        }
    }
}

