/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.openapi.util.text.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryString {
    public static final QueryString EMPTY = new QueryString();
    protected List<Parameter> myParameters = new ArrayList<Parameter>();

    @NotNull
    public QueryString addParameter(@NotNull String name, @NotNull String value) {
        if (name == null) {
            QueryString.$$$reportNull$$$0(0);
        }
        if (value == null) {
            QueryString.$$$reportNull$$$0(1);
        }
        this.myParameters.add(new Parameter(name, value));
        QueryString queryString = this;
        if (queryString == null) {
            QueryString.$$$reportNull$$$0(2);
        }
        return queryString;
    }

    @NotNull
    public QueryString addParameter(@NotNull String name) {
        if (name == null) {
            QueryString.$$$reportNull$$$0(3);
        }
        QueryString queryString = this.addParameter(name, "");
        if (queryString == null) {
            QueryString.$$$reportNull$$$0(4);
        }
        return queryString;
    }

    @Nullable
    public String getParameterValue(@NotNull String parameterName) {
        if (parameterName == null) {
            QueryString.$$$reportNull$$$0(5);
        }
        for (Parameter parameter : this.myParameters) {
            if (!parameterName.equals(parameter.getName())) continue;
            return parameter.getValue();
        }
        return null;
    }

    @NotNull
    public QueryString unionWith(@NotNull QueryString queryString) {
        if (queryString == null) {
            QueryString.$$$reportNull$$$0(6);
        }
        for (Parameter parameter : queryString.myParameters) {
            this.addParameter(parameter.getName(), parameter.getValue());
        }
        QueryString queryString2 = this;
        if (queryString2 == null) {
            QueryString.$$$reportNull$$$0(7);
        }
        return queryString2;
    }

    @NotNull
    public final String toString() {
        StringBuilder queryBuilder = new StringBuilder();
        Iterator<Parameter> nameValueIterator = this.myParameters.iterator();
        while (nameValueIterator.hasNext()) {
            try {
                Parameter nameValue = nameValueIterator.next();
                String encodedName = URLEncoder.encode(nameValue.getName(), "UTF-8");
                queryBuilder.append(encodedName);
                String value = nameValue.getValue();
                if (!StringUtil.isEmptyOrSpaces((String)value)) {
                    String encodedParameterValue = URLEncoder.encode(value, "UTF-8");
                    queryBuilder.append("=").append(encodedParameterValue);
                }
                if (!nameValueIterator.hasNext()) continue;
                queryBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String string = queryBuilder.toString();
        if (string == null) {
            QueryString.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public final Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter parameter : this.myParameters) {
            map.put(parameter.getName(), parameter.getValue());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            QueryString.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    public boolean isEmpty() {
        return this.myParameters.isEmpty();
    }

    @NotNull
    public static QueryString parse(@NotNull String input) {
        if (input == null) {
            QueryString.$$$reportNull$$$0(10);
        }
        QueryString queryString = new QueryString();
        List nameValueList = StringUtil.split((String)input, (String)"&");
        for (String nameValue : nameValueList) {
            int equalityPosition = nameValue.indexOf("=");
            if (equalityPosition == -1) {
                queryString.addParameter(nameValue);
                continue;
            }
            if (equalityPosition <= 0) continue;
            String name = nameValue.substring(0, equalityPosition);
            String value = nameValue.substring(equalityPosition + 1);
            queryString.addParameter(name, value);
        }
        QueryString queryString2 = queryString;
        if (queryString2 == null) {
            QueryString.$$$reportNull$$$0(11);
        }
        return queryString2;
    }

    public static QueryString empty() {
        return EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/QueryString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryString";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/QueryString";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unionWith";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameterValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unionWith";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Parameter {
        @NotNull
        private final String myName;
        @NotNull
        private final String myValue;

        Parameter(@NotNull String name, @NotNull String value) {
            if (name == null) {
                Parameter.$$$reportNull$$$0(0);
            }
            if (value == null) {
                Parameter.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myValue = value;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Parameter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                Parameter.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/util/QueryString$Parameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/util/QueryString$Parameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

