/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurableList<C extends QualityToolConfiguration>
extends PhpNamedCloneableItemsListEditor<C> {
    private static final Comparator<MasterDetailsComponent.MyNode> COMPARATOR = (n1, n2) -> {
        Object o1 = n1.getConfigurable().getEditableObject();
        Object o2 = n2.getConfigurable().getEditableObject();
        if (o1 instanceof QualityToolConfiguration && o2 instanceof QualityToolConfiguration) {
            return ((QualityToolConfiguration)o1).compareTo((QualityToolConfiguration)o2);
        }
        return StringUtil.naturalCompare((String)n1.getDisplayName(), (String)n2.getDisplayName());
    };
    private final Project myProject;

    public QualityToolConfigurableList(@NotNull Project project, @NotNull QualityToolConfigurationManager<C> configurationManager, @NotNull NotNullFactory<C> factory, @NotNull PhpNamedCloneableItemsListEditor.Cloner<C> cloner, @NotNull PhpNamedCloneableItemsListEditor.ConfigurableFactory<C> configurableFactory, @Nullable String initialElement) {
        if (project == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(0);
        }
        if (configurationManager == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(2);
        }
        if (cloner == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(3);
        }
        if (configurableFactory == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(4);
        }
        super(new QualityToolConfigurationNamer(project), factory, cloner, () -> {
            if (configurationManager == null) {
                QualityToolConfigurableList.$$$reportNull$$$0(8);
            }
            return configurationManager.getAllSettings();
        }, settings -> {
            if (configurationManager == null) {
                QualityToolConfigurableList.$$$reportNull$$$0(7);
            }
            configurationManager.setSettings(settings);
        }, configurableFactory, new PhpNamedCloneableItemsListEditor.DefaultItemModelHandler(), initialElement);
        this.myProject = project;
    }

    @Nullable
    public String getLastSelectedItemId() {
        return this.myLastSelectedItem != null ? ((QualityToolConfiguration)this.myLastSelectedItem).getId() : null;
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List list = this.getConfigurationProvider() == null ? ContainerUtil.newArrayList() : super.createActions(fromPopup);
        if (list == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    protected boolean canDelete(C item) {
        return item != null && !item.isLocal();
    }

    @Override
    protected boolean isCopyAvailable() {
        return false;
    }

    @Override
    @NotNull
    protected String suggestName(C item) {
        String string = item.getPresentableName(this.myProject);
        if (string == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected AnAction createAddAction() {
        return new PhpNamedCloneableItemsListEditor.AddAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent event) {
                QualityToolConfigurationProvider provider;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((provider = QualityToolConfigurableList.this.getConfigurationProvider()) != null) {
                    ArrayList allSettings = ContainerUtil.newArrayList();
                    QualityToolConfigurableList.this.getItemConfigurables().forEach(configurable -> ContainerUtil.addIfNotNull((Collection)allSettings, QualityToolConfigurableList.this.getConfiguration((UnnamedConfigurable)configurable)));
                    Object settings = provider.createNewInstance(QualityToolConfigurableList.this.myProject, allSettings);
                    if (settings != null) {
                        QualityToolConfigurableList.this.onItemCreated(settings);
                    }
                } else {
                    super.actionPerformed(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/tools/quality/QualityToolConfigurableList$1", "actionPerformed"));
            }
        };
    }

    @Nullable
    protected abstract QualityToolConfigurationProvider<C> getConfigurationProvider();

    @Nullable
    protected C getConfiguration(@Nullable UnnamedConfigurable configurable) {
        if (configurable instanceof QualityToolConfigurableForm) {
            return this.getConfiguration((QualityToolConfiguration)((QualityToolConfigurableForm)configurable).getConfiguration());
        }
        return null;
    }

    @Nullable
    protected abstract C getConfiguration(@Nullable QualityToolConfiguration var1);

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return COMPARATOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableFactory";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QualityToolConfigurationNamer<C extends QualityToolConfiguration>
    implements Namer<C> {
        private final Project myProject;

        QualityToolConfigurationNamer(Project project) {
            this.myProject = project;
        }

        public String getName(C settings) {
            return settings.getPresentableName(this.myProject);
        }

        public boolean canRename(C item) {
            return false;
        }

        public void setName(C settings, String newName) {
        }
    }
}

