/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolProjectConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolsIgnoreFilesConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class QualityToolAddToIgnoredAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Collection<VirtualFile> selectedFiles = this.getSelectedFiles(dataContext);
        if (selectedFiles.size() == 0) {
            return;
        }
        if (project != null) {
            QualityToolBlackList blackList = this.getBlackList(project);
            selectedFiles.forEach(blackList::addFile);
            this.showConfigurable(project, selectedFiles);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        if (this.getSelectedFiles(e.getDataContext()).size() == 0) {
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setText(this.getToolName());
    }

    @NotNull
    private Collection<VirtualFile> getSelectedFiles(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                QualityToolAddToIgnoredAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<VirtualFile> filteredFiles = new ArrayList<VirtualFile>();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        QualityToolBlackList blackList = this.getBlackList(project);
        if (selectedFiles != null) {
            for (VirtualFile file : selectedFiles) {
                if (blackList.containsFile(file) || !((Object)((Object)PhpFileType.INSTANCE)).equals(file.getFileType())) continue;
                filteredFiles.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = filteredFiles;
        if (arrayList == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    protected abstract QualityToolBlackList getBlackList(Project var1);

    @NotNull
    protected abstract String getToolName();

    @NotNull
    protected abstract QualityToolProjectConfigurableForm getToolConfigurable(@NotNull Project var1);

    protected abstract QualityToolsIgnoreFilesConfigurable getIgnoredFilesConfigurable(@NotNull Project var1);

    private void showConfigurable(@NotNull Project project, @NotNull Collection<VirtualFile> selectedFiles) {
        if (project == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(5);
        }
        if (selectedFiles == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(6);
        }
        QualityToolsIgnoreFilesConfigurable ignoredFilesConfigurable = this.getIgnoredFilesConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)ignoredFilesConfigurable, () -> {
            if (selectedFiles == null) {
                QualityToolAddToIgnoredAction.$$$reportNull$$$0(7);
            }
            ignoredFilesConfigurable.selectFiles(selectedFiles);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAddToIgnoredAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAddToIgnoredAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFiles";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showConfigurable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showConfigurable$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

