/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.stringDoc;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.rename.PhpHeredocRenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStringToHeredocIntention
extends PsiElementBaseIntentionAction {
    public static final String FAMILY_NAME = "Convert string literal to HEREDOC/NOWDOC";
    public static final String HEREDOC_NAME = "Convert string literal to HEREDOC";
    public static final String NOWDOC_NAME = "Convert string literal to NOWDOC";
    private static final String SINGLE_QUOTE = "'";
    public static final String SLASH = "\\";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String HEREDOC_BEGIN = "<<<";

    static PsiElement hasSemicolon(PsiElement expression) {
        int nextElementOffset;
        PsiFile file = expression.getContainingFile();
        PsiElement nextElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)(nextElementOffset = expression.getTextRange().getEndOffset()));
        if (nextElement instanceof PsiWhiteSpace) {
            int end = nextElement.getTextRange().getEndOffset();
            nextElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)end);
        }
        if (PhpPsiUtil.isOfType(nextElement, PhpTokenTypes.opSEMICOLON)) {
            return nextElement;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(1);
        }
        String name = "TAG";
        ASTNode node = element.getNode();
        if (PhpPsiUtil.isOfType(node, PhpTokenTypes.chRSINGLE_QUOTE)) {
            element = element.getPrevSibling();
        }
        boolean isSingleQuoted = PhpPsiUtil.isOfType(element, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpTokenTypes.chLSINGLE_QUOTE);
        boolean doubleQuoted = PhpPsiUtil.isOfType(element, PhpTokenTypes.STRING_LITERAL) || PhpStringToHeredocIntention.stringLiteral(element, PhpTokenTypes.STRING_LITERAL);
        PsiElement stringExpression = PhpStringToHeredocIntention.getStringExpression(element);
        if (isSingleQuoted || doubleQuoted) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                name = this.getName(project, name, stringExpression, doubleQuoted);
            }
            if (name != null) {
                String docChar;
                String text = stringExpression.getText();
                PsiElement firstChild = stringExpression.getFirstChild();
                int lengthOfFirstQuote = firstChild.getTextLength();
                String binary = "";
                String firstChildText = firstChild.getText();
                if (firstChildText.startsWith("b") || firstChildText.startsWith("B")) {
                    binary = firstChildText.substring(0, 1);
                }
                String cutted = text.substring(lengthOfFirstQuote, text.length() - 1);
                cutted = PhpStringToHeredocIntention.unescapeSymbols(cutted, isSingleQuoted);
                String string = docChar = isSingleQuoted ? SINGLE_QUOTE : "";
                if (isSingleQuoted) {
                    name = PhpStringToHeredocIntention.cutQuotes(name);
                }
                int length = cutted.length();
                StringBuilder docText = new StringBuilder().append(binary).append(HEREDOC_BEGIN).append(docChar).append(name).append(docChar).append("\n").append(length > 0 ? cutted + "\n" : "").append(PhpStringToHeredocIntention.cutQuotes(name));
                PsiFile file = element.getContainingFile();
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
                Document doc = editor.getDocument();
                int expressionTextOffset = stringExpression.getTextOffset();
                int expressionEnd = expressionTextOffset + stringExpression.getTextLength();
                PsiElement semicolon = PhpStringToHeredocIntention.hasSemicolon(stringExpression);
                if (semicolon != null) {
                    StringBuilder toReplace = new StringBuilder().append(";");
                    Object thisStatement = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                    if (thisStatement != null) {
                        PsiElement nextStatement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(thisStatement, true);
                        int semicolonLineNumber = doc.getLineNumber(semicolon.getTextOffset());
                        if (semicolonLineNumber == doc.getLineCount() - 1 || nextStatement != null && semicolonLineNumber == doc.getLineNumber(nextStatement.getTextOffset()) || thisStatement.getTextRange().getEndOffset() > semicolon.getTextOffset() + 1) {
                            toReplace.append("\n");
                        }
                    }
                    if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> doc.replaceString(expressionEnd, semicolon.getTextOffset() + 1, (CharSequence)toReplace));
                } else {
                    docText.append("\n");
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> doc.replaceString(expressionTextOffset, expressionEnd, (CharSequence)docText));
                manager.commitDocument(doc);
            }
        }
    }

    public static String cutQuotes(String name) {
        if (PhpNameUtil.isPhpIdentifierInDoubleQuotes(name)) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    private static String unescapeSymbols(String arg, boolean isSingleQuoted) {
        if (isSingleQuoted) {
            arg = arg.replace("\\'", SINGLE_QUOTE);
            arg = arg.replace("\\\\", SLASH);
        } else {
            arg = arg.replace("\\\"", DOUBLE_QUOTE);
        }
        return arg;
    }

    public String getName(Project project, String name, PsiElement expression, boolean doubleQuotes) {
        return PhpHeredocRenameHandler.getNameFromDialog(project, "Enter tag name", expression, name, doubleQuotes, true);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        ASTNode node = element.getNode();
        if (PhpPsiUtil.isOfType(node, PhpTokenTypes.chRSINGLE_QUOTE) || PhpPsiUtil.isOfType(node, PhpTokenTypes.chRDOUBLE_QUOTE)) {
            element = element.getPrevSibling();
        }
        if (node == null) {
            return false;
        }
        if (PhpStringToHeredocIntention.stringLiteral(element, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE)) {
            this.setText(NOWDOC_NAME);
            return true;
        }
        if (PhpStringToHeredocIntention.stringLiteral(element, PhpTokenTypes.STRING_LITERAL)) {
            this.setText(HEREDOC_NAME);
            return true;
        }
        return false;
    }

    private static boolean stringLiteral(@Nullable PsiElement element, IElementType elementType) {
        if (element != null) {
            boolean complexDoubleQuoteString;
            PsiElement stringExpression = PhpStringToHeredocIntention.getStringExpression(element);
            boolean bl = complexDoubleQuoteString = stringExpression != null && stringExpression.getNode().getFirstChildNode().getElementType() == PhpTokenTypes.chLDOUBLE_QUOTE && elementType == PhpTokenTypes.STRING_LITERAL;
            if (PhpPsiUtil.isOfType(element, elementType, PhpTokenTypes.chLSINGLE_QUOTE) || complexDoubleQuoteString) {
                return true;
            }
        }
        return false;
    }

    private static PsiElement getStringExpression(PsiElement element) {
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
    }

    @NotNull
    public String getFamilyName() {
        if (FAMILY_NAME == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(4);
        }
        return FAMILY_NAME;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/stringDoc/PhpStringToHeredocIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/stringDoc/PhpStringToHeredocIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

