/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.refactoring.PhpNameUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceWithAliasIntention
extends PsiElementBaseIntentionAction {
    public static final String TEXT = PhpBundle.message("intention.replace.class.with.alias", new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpPsiElement scope;
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(1);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(element = PhpReplaceWithAliasIntention.getLogicalElement(editor, element))) == null) {
            return;
        }
        PhpUse use = PhpReplaceWithAliasIntention.resolveUseWithoutAlias(element);
        if (use == null) {
            return;
        }
        PhpUse useWithAlias = PhpReplaceWithAliasIntention.replaceUseDeclarationAndReferencesWithAlias(use, scope);
        PhpReplaceWithAliasIntention.runRename(project, editor, element, useWithAlias);
    }

    private static void runRename(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element, @NotNull PhpUse useWithAlias) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(4);
        }
        if (useWithAlias == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(5);
        }
        if (PhpReplaceWithAliasIntention.getUseDirectly(element) != null) {
            ASTNode node = useWithAlias.getNameNode();
            if (node == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(node.getStartOffset() + node.getTextLength());
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        RenameHandler handler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
        if (handler == null) {
            return;
        }
        handler.invoke(project, editor, useWithAlias.getContainingFile(), dataContext);
    }

    private static PhpUse replaceUseDeclarationAndReferencesWithAlias(@NotNull PhpUse use, @NotNull PhpPsiElement scope) {
        if (use == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(7);
        }
        Project project = use.getProject();
        PhpUse useWithAlias = PhpReplaceWithAliasIntention.createUseWithAlias(project, use, PhpReplaceWithAliasIntention.createUniqueClassAliasName(scope, use));
        Collection<PsiReference> references = PhpCodeInsightUtil.collectReferencesToAlias(use);
        return (PhpUse)ApplicationManager.getApplication().runWriteAction(() -> {
            if (use == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(24);
            }
            ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{use.getContainingFile().getVirtualFile()});
            for (PsiReference reference : references) {
                PhpReplaceWithAliasIntention.replaceReference(project, reference, useWithAlias.getName());
            }
            return (PhpUse)use.replace((PsiElement)useWithAlias);
        });
    }

    static void replaceReference(Project project, PsiReference reference, String name) {
        if (reference instanceof FunctionReference) {
            PhpReplaceWithAliasIntention.replaceFunctionReference((FunctionReference)reference, name);
        } else if (reference instanceof ConstantReference) {
            ((ConstantReference)reference).replace((PsiElement)PhpPsiElementFactory.createConstantReference(project, name));
        } else if (reference instanceof PhpPsiElement) {
            PhpImportClassIntention.replaceClassReference((PhpPsiElement)reference, name);
        } else {
            PhpNamespaceReference namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)reference.getElement(), PhpNamespaceReference.class);
            if (namespaceReference != null) {
                PhpReplaceWithAliasIntention.replaceFirstPartOfNamespaceReference(project, namespaceReference, name);
            }
        }
    }

    private static void replaceFirstPartOfNamespaceReference(Project project, PhpNamespaceReference namespaceReference, String name) {
        String fullName = StringUtil.trimEnd((String)namespaceReference.getText(), (String)"\\");
        int firstDelimiter = fullName.indexOf("\\");
        String namespaceName = firstDelimiter >= 0 ? name + fullName.substring(firstDelimiter) : name;
        boolean inDoc = PhpPsiUtil.getParentByCondition((PsiElement)namespaceReference, false, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
        namespaceReference.replace((PsiElement)PhpPsiElementFactory.createNamespaceReference(project, namespaceName, inDoc));
    }

    private static void replaceFunctionReference(FunctionReference reference, String aliasName) {
        ParameterList list = reference.getParameterList();
        String parameterListText = list != null ? list.getText() : "";
        reference.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(reference.getProject(), aliasName + "(" + parameterListText + ")"));
    }

    @NotNull
    static PhpUse createUseWithAlias(@NotNull Project project, @NotNull PhpUse originalUse, @Nullable String aliasName) {
        PhpUseList useList;
        PhpNamespaceReference useListNamespaceReference;
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(8);
        }
        if (originalUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(9);
        }
        PhpNamespaceReference phpNamespaceReference = useListNamespaceReference = (useList = PhpUseImpl.getUseList((PsiElement)originalUse)) != null ? useList.getNamespaceReference() : null;
        if (useListNamespaceReference != null) {
            PhpUse phpUse = PhpReplaceWithAliasIntention.createUseInGroupStatement(project, aliasName, useList, originalUse.getFQN(), useListNamespaceReference);
            if (phpUse == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(10);
            }
            return phpUse;
        }
        String keyword = PhpGroupUseElement.getKeyword(originalUse, useList);
        PhpUse phpUse = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, originalUse.getFQN(), aliasName).getDeclarations()[0];
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(11);
        }
        return phpUse;
    }

    @NotNull
    private static String createUniqueClassAliasName(@NotNull PhpPsiElement scope, @NotNull PhpUse use) {
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(12);
        }
        if (use == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(13);
        }
        PhpGroupUseElement.PhpUseKeyword keyword = PhpReplaceWithAliasIntention.getUseKeyword(PhpGroupUseElement.getKeyword(use, PhpUseImpl.getUseList((PsiElement)use)));
        THashSet aliases = new THashSet(PhpImportClassIntention.collectUsedAliases(scope, keyword), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        String aliasCandidate = PhpLangUtil.toShortName(use.getName()) + "Alias";
        String string = PhpNameUtil.unique(aliasCandidate, "", "", (Condition<? super String>)((Condition)((Set)aliases)::contains));
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static PhpUse createUseInGroupStatement(@NotNull Project project, String aliasName, PhpUseList useList, String originalUseFQN, PhpNamespaceReference namespaceReference) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(15);
        }
        PhpUse[] declarations = useList.getDeclarations();
        ArrayList<PhpGroupUseElement> uses = new ArrayList<PhpGroupUseElement>(declarations.length);
        int replacedUseWithAliasIndex = PhpReplaceWithAliasIntention.collectDeclarationsAndReplaceOriginalWithAlias(declarations, originalUseFQN, aliasName, uses);
        boolean trailingComma = PhpUseListImpl.getTrailingComma(useList) != null;
        PhpUse phpUse = PhpPsiElementFactory.createGroupUseStatement(project, null, PhpLangUtil.toFQN(namespaceReference.getFullName()), uses, trailingComma).getDeclarations()[replacedUseWithAliasIndex];
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(16);
        }
        return phpUse;
    }

    private static int collectDeclarationsAndReplaceOriginalWithAlias(PhpUse[] declarations, String originalUseFQN, String aliasName, Collection<PhpGroupUseElement> uses) {
        int replacedIndex = -1;
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            PhpUse declaration = declarations[i];
            if (PhpLangUtil.equalsClassNames(declaration.getFQN(), originalUseFQN)) {
                replacedIndex = i;
                uses.add(new PhpGroupUseElement(declaration, aliasName));
                continue;
            }
            uses.add(new PhpGroupUseElement(declaration));
        }
        assert (replacedIndex >= 0) : "Can't find replaced use. Original use fqn: " + originalUseFQN + ". Result declarations:\n" + uses.stream().map(PhpGroupUseElement::toString).collect(Collectors.joining());
        return replacedIndex;
    }

    @NotNull
    private static PhpGroupUseElement.PhpUseKeyword getUseKeyword(String value) {
        for (PhpGroupUseElement.PhpUseKeyword keyword : PhpGroupUseElement.PhpUseKeyword.values()) {
            if (!StringUtil.equals((CharSequence)keyword.getValue(), (CharSequence)value)) continue;
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = keyword;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(17);
            }
            return phpUseKeyword;
        }
        throw new IllegalArgumentException();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(18);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(19);
        }
        if ((element = PhpReplaceWithAliasIntention.getLogicalElement(editor, element)) == null || !PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scope == null) {
            return false;
        }
        return PhpReplaceWithAliasIntention.resolveUseWithoutAlias(element) != null;
    }

    private static PsiElement getLogicalElement(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(20);
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.IDENTIFIER)) {
            return element.getContainingFile().findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        return element;
    }

    @Nullable
    private static PhpUse resolveUseWithoutAlias(@NotNull PsiElement element) {
        PhpUse use;
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(21);
        }
        if ((use = PhpReplaceWithAliasIntention.getUseDirectly(element)) != null) {
            return use.getAliasName() == null ? use : null;
        }
        PhpReference reference = (PhpReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (reference == null) {
            return null;
        }
        return StreamEx.of((Collection)reference.resolveLocal()).select(PhpUse.class).findFirst(d -> d.getAliasName() == null).orElse(null);
    }

    @Nullable
    private static PhpUse getUseDirectly(@Nullable PsiElement element) {
        return (PhpUse)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(23);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useWithAlias";
                break;
            }
            case 6: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUse";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseWithAlias";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueClassAliasName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseInGroupStatement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseKeyword";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runRename";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceUseDeclarationAndReferencesWithAlias";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createUseWithAlias";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueClassAliasName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createUseInGroupStatement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveUseWithoutAlias";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceUseDeclarationAndReferencesWithAlias$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

