/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpNonCanonicalElementsOrderInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpFlipVariableAndTypeQuickFix.access$000()};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNonCanonicalElementsOrderInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpDocTag(PhpDocTag tag) {
                if (tag instanceof PhpDocPropertyTag) {
                    PhpDocType type = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
                    if (type == null && !tag.getTagValue().isEmpty()) {
                        holder.registerProblem((PsiElement)tag, "Probably non-canonical order of variable and type", new LocalQuickFix[0]);
                    }
                } else if (tag instanceof PhpDocParamTag) {
                    PhpDocVariable variable = null;
                    for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child instanceof PhpDocVariable) {
                            variable = (PhpDocVariable)child;
                            continue;
                        }
                        if (!(child instanceof PhpDocType)) continue;
                        if (variable != null) {
                            holder.registerProblem((PsiElement)tag, "Non-canonical order of variable and type", FIXES);
                        }
                        return;
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpNonCanonicalElementsOrderInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpFlipVariableAndTypeQuickFix
    extends PhpQuickFixBase {
        private static final PhpFlipVariableAndTypeQuickFix INSTANCE = new PhpFlipVariableAndTypeQuickFix();

        private PhpFlipVariableAndTypeQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Flip variable and type" == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(0);
            }
            return "Flip variable and type";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(2);
            }
            PhpDocTag tag = (PhpDocTag)descriptor.getPsiElement();
            PhpDocVariable variable = (PhpDocVariable)PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocVariable.INSTANCEOF);
            PhpDocType type = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
            PhpDocType lastType = PhpFlipVariableAndTypeQuickFix.getLastType(type);
            if (variable != null && type != null) {
                tag.addRangeBefore((PsiElement)type, (PsiElement)lastType, (PsiElement)variable);
                tag.deleteChildRange((PsiElement)type, (PsiElement)lastType);
            }
        }

        private static PhpDocType getLastType(PhpDocType type) {
            PsiElement next;
            PhpDocType lastType = type;
            PsiElement psiElement = next = type != null ? type.getNextSibling() : null;
            while (next != null) {
                if (next instanceof PhpDocType) {
                    lastType = (PhpDocType)next;
                }
                next = next.getNextSibling();
            }
            return lastType;
        }

        static /* synthetic */ PhpFlipVariableAndTypeQuickFix access$000() {
            return INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection$PhpFlipVariableAndTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection$PhpFlipVariableAndTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

