/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.validation.PhpWebServerValidator;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteWebServerValidator
extends PhpWebServerValidator {
    private static final Logger LOG = Logger.getInstance(PhpRemoteWebServerValidator.class);
    protected final Deployable myDeployable;
    private final PublishConfig myPublishConfig;
    private final JComponent myParent;

    public PhpRemoteWebServerValidator(@NotNull Project project, @Nullable Deployable server, @NotNull JComponent parent) {
        if (project == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(1);
        }
        super(project);
        this.myParent = parent;
        this.myDeployable = server;
        this.myPublishConfig = PublishConfig.getInstance((Project)project).clone();
        this.myPublishConfig.setOverwriteAll(false);
        this.myPublishConfig.setStopOnFirstError(true);
        this.myPublishConfig.setFilePermissions(420);
    }

    @Override
    @Nullable
    protected String getMessage(Throwable throwable, boolean full) {
        return PublishUtils.getMessage((Throwable)throwable, (boolean)false);
    }

    @Override
    @Nullable
    protected String doTestConnection() {
        if (!AuthHelper.ensureAuthSpecified((Project)this.myProject, (Deployable)this.myDeployable, (Component)this.myParent)) {
            return "Authentication data is not specified";
        }
        try {
            String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{this.myDeployable.getAccessType().getTitle()});
            PublishUtils.testConnection((Deployable)this.myDeployable, (JComponent)this.myParent, (String)title, (boolean)false);
        }
        catch (FileSystemException e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    @NotNull
    protected PhpInfoValidationMessage getMessageForNotAFileException(@NotNull String path, @NotNull String webPath, @Nullable String originalException) {
        if (path == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(2);
        }
        if (webPath == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(3);
        }
        String presentableWebPath = StringUtil.endsWith((CharSequence)webPath, (CharSequence)"/") ? webPath : webPath + "/";
        String deploymentServerName = this.myDeployable == null ? "remote" : "<b>" + this.myDeployable.getName() + "</b>";
        String description = "Validation script will be created in <b>'" + path + "'</b> directory and deployed to the " + deploymentServerName + " server.<br>Files in the remote directory should be accessible by <b>'" + presentableWebPath + "file_name'</b> request.<br>Follow this <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Deploying+PHP+applications+with+PhpStorm#DeployingPHPapplicationswithPhpStorm-1.3.Configuremappings\">link</a> for more information about path mappings." + (StringUtil.isEmpty((String)originalException) ? "" : "<br><br>Caused by: \"" + originalException + "\"");
        PhpInfoValidationMessage phpInfoValidationMessage = PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.script.result.path.mapping.check", path), description);
        if (phpInfoValidationMessage == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(4);
        }
        return phpInfoValidationMessage;
    }

    @Override
    @Nullable
    protected String validateWebServerConfiguration(@NotNull VirtualFile baseDir, @NotNull JComponent parentComponent) {
        if (baseDir == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(5);
        }
        if (parentComponent == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(6);
        }
        if (this.myDeployable == null) {
            return PhpBundle.message("php.web.server.validation.failed.to.find.deployment.settings", new Object[0]);
        }
        DeploymentPathMapping deploymentPath = (DeploymentPathMapping)this.myPublishConfig.getNearestMappingForLocal(baseDir.getPath(), false, true, true, (Mappable)this.myDeployable).getFirst();
        if (this.myDeployable.needsTransfer() && (deploymentPath == null || !deploymentPath.isWebPathValid())) {
            return PhpBundle.message("php.web.server.validation.failed.to.map.deployment.folder", new Object[0]);
        }
        if (this.myDeployable.needsTransfer() && !AuthHelper.ensureAuthSpecified((Project)this.myProject, (Deployable)this.myDeployable, (Component)parentComponent)) {
            return PhpBundle.message("php.web.server.validation.failed.to.deploy.validation.script", new Object[0]);
        }
        return null;
    }

    @Override
    protected String getWebPathToValidationDir(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(7);
        }
        return this.myPublishConfig.mapToWebPath(baseDir.getPath(), (Mappable)this.myDeployable);
    }

    @Override
    protected boolean uploadScript(final @NotNull VirtualFile baseDir, final @NotNull Ref<WebServerConfig.RemotePath> script, @NotNull List<PhpInfoValidationMessage> messages) {
        if (baseDir == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(8);
        }
        if (script == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(9);
        }
        if (messages == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(10);
        }
        if (this.myDeployable != null && this.myDeployable.needsTransfer()) {
            TransferScriptTask task = new TransferScriptTask(this.myProject, this.myPublishConfig, this.myDeployable, PhpBundle.message("php.web.server.validation.uploading.validation.script", this.myDeployable.getName()), true){

                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                    ArrayList<TransferOperation.CreateRemoteFile> operations = new ArrayList<TransferOperation.CreateRemoteFile>();
                    DeploymentPathMapping launcherMapping = (DeploymentPathMapping)this.myPublishConfig.getNearestMappingForLocal(baseDir.getPath(), false, true, true, (Mappable)PhpRemoteWebServerValidator.this.myDeployable).getFirst();
                    LOG.assertTrue(launcherMapping != null && launcherMapping.isWebPathValid(), (Object)("no valid mapping for " + baseDir.getPath()));
                    String launcherFakeLocalPath = DeploymentPathUtils.join((String)baseDir.getPath(), (String)"_intellij_phpdebug_validator.php");
                    script.set((Object)launcherMapping.mapToDeployPath(launcherFakeLocalPath, (Mappable)PhpRemoteWebServerValidator.this.myDeployable));
                    FileObject launcherFileTarget = context.findRemoteFile(launcherMapping.mapToDeployPath(launcherFakeLocalPath, (Mappable)PhpRemoteWebServerValidator.this.myDeployable), true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Launcher file path: " + launcherFileTarget.getName().getURI());
                    }
                    TransferOperation.CreateRemoteFile op = new TransferOperation.CreateRemoteFile(PhpWebServerValidator.getLauncherText(), launcherFileTarget);
                    operations.add(op);
                    return new TransferTask.ListBased.ResultWithErrors(operations, new DeploymentPathUtils.ErrorsAndExclusions());
                }
            };
            boolean execute = task.execute();
            if (!execute) {
                for (String error : task.getErrors()) {
                    messages.add(PhpInfoValidationMessage.failed(error, null));
                }
            }
            return execute;
        }
        return super.uploadScript(baseDir, script, messages);
    }

    @Override
    protected void cleanup(@NotNull VirtualFile baseDir, final @NotNull Ref<WebServerConfig.RemotePath> script) {
        if (baseDir == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(11);
        }
        if (script == null) {
            PhpRemoteWebServerValidator.$$$reportNull$$$0(12);
        }
        if (this.myDeployable != null && this.myDeployable.needsTransfer()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (script == null) {
                    PhpRemoteWebServerValidator.$$$reportNull$$$0(13);
                }
                new TransferScriptTask(this.myProject, this.myPublishConfig, this.myDeployable, PhpBundle.message("cleaning.up", this.myDeployable.getName()), true){

                    protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                        ArrayList<TransferOperation.Delete> result = new ArrayList<TransferOperation.Delete>();
                        FileObject file = context.findRemoteFile((WebServerConfig.RemotePath)script.get(), true);
                        if (file.exists()) {
                            result.add(new TransferOperation.Delete(file, file.getType() == FileType.FOLDER, true));
                        }
                        return new TransferTask.ListBased.ResultWithErrors(result, new DeploymentPathUtils.ErrorsAndExclusions());
                    }
                }.queue();
            });
        } else {
            super.cleanup(baseDir, script);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpRemoteWebServerValidator";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpRemoteWebServerValidator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageForNotAFileException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForNotAFileException";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateWebServerConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWebPathToValidationDir";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uploadScript";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cleanup$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class TransferScriptTask
    extends TransferTask.ListBased {
        private final List<String> myErrors;
        private final Semaphore myDone;
        private volatile boolean myResult;

        TransferScriptTask(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Deployable deployable, @NotNull String title, boolean cancellable) {
            if (project == null) {
                TransferScriptTask.$$$reportNull$$$0(0);
            }
            if (publishConfig == null) {
                TransferScriptTask.$$$reportNull$$$0(1);
            }
            if (deployable == null) {
                TransferScriptTask.$$$reportNull$$$0(2);
            }
            if (title == null) {
                TransferScriptTask.$$$reportNull$$$0(3);
            }
            super(project, (ConnectionOwner)ConnectionOwnerFactory.createConnectionOwner((Project)project), true, publishConfig, deployable, title, false, true, cancellable, ProjectDeploymentRevisionTracker.getInstance((Project)project), DeploymentMode.CUSTOM);
            this.myErrors = new SmartList();
            this.myDone = new Semaphore();
        }

        private List<String> getErrors() {
            return this.myErrors;
        }

        public void run(@NotNull ProgressIndicator pi) {
            if (pi == null) {
                TransferScriptTask.$$$reportNull$$$0(4);
            }
            try {
                this.myResult = this.doRun(pi);
            }
            finally {
                this.myDone.up();
            }
        }

        public final void queue(@Nullable ProgressIndicator pi) {
            if (pi == null) {
                ProgressManager.getInstance().run((Task)this);
            } else {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, pi);
            }
        }

        public boolean execute() {
            ProgressIndicator pi = this.getProgressIndicator();
            this.myDone.down();
            ApplicationManager.getApplication().invokeLater(() -> this.queue(pi));
            this.myDone.waitFor();
            return this.myResult;
        }

        @Nullable
        public ProgressIndicator getProgressIndicator() {
            if (ProgressManager.getInstance().hasProgressIndicator() && ProgressManager.getInstance().getProgressIndicator().isRunning()) {
                return ProgressWrapper.wrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            }
            return null;
        }

        protected boolean canChangeProgressText() {
            return false;
        }

        protected boolean isTolerateSetPermissionsErrors() {
            return true;
        }

        protected void print(String text, ConsoleViewContentType contentType) {
            if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
                this.myErrors.add(text);
                LOG.warn(text);
            } else {
                LOG.info(text);
            }
        }

        protected void showBalloon(MessageType type, String text, boolean isSummary) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "publishConfig";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pi";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/validation/PhpRemoteWebServerValidator$TransferScriptTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

