/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManager;
import com.jetbrains.php.config.interpreters.PhpInterpretersStateListener;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInterpretersBaseManager
implements PersistentStateComponent<Element>,
PhpInterpretersManager {
    private static final SerializationFilter myFilter = new SkipDefaultValuesSerializationFilters();
    private static final String INTERPRETERS = "interpreters";
    private static final String INTERPRETER = "interpreter";
    private static final String ROOT = "root";
    private List<PhpInterpreter> myInterpreters = new ArrayList<PhpInterpreter>();
    private final List<PhpInterpretersStateListener> myStateListeners = new SmartList();

    public Element getState() {
        Element root = new Element(ROOT);
        if (this.myInterpreters.isEmpty()) {
            return root;
        }
        Element element = new Element(INTERPRETERS);
        for (PhpInterpreter interpreter : this.myInterpreters) {
            Element interpreterElement = XmlSerializer.serialize((Object)interpreter, (SerializationFilter)myFilter);
            SdkAdditionalData data = interpreter.getSdkAdditionalData();
            if (data != null) {
                interpreter.getSdkType().saveAdditionalData(data, interpreterElement);
            }
            element.addContent(interpreterElement);
        }
        root.addContent(element);
        return root;
    }

    public void loadState(@NotNull Element element) {
        List children;
        if (element == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(0);
        }
        this.myInterpreters.clear();
        Element interpreters = element == null ? null : element.getChild(INTERPRETERS);
        List list = children = interpreters == null ? null : interpreters.getChildren(INTERPRETER);
        if (children == null) {
            return;
        }
        for (Object child : children) {
            Element interpreterElement = (Element)child;
            PhpInterpreter interpreter = (PhpInterpreter)XmlSerializer.deserialize((Element)interpreterElement, PhpInterpreter.class);
            SdkAdditionalData data = interpreter.getSdkType().loadAdditionalData((Sdk)interpreter, interpreterElement);
            interpreter.setSdkAdditionalData(data);
            this.finishInitialization(interpreter);
            this.myInterpreters.add(interpreter);
        }
        this.onInterpretersUpdate();
    }

    protected void onInterpretersUpdate() {
        for (PhpInterpretersStateListener listener : this.myStateListeners) {
            listener.onInterpretersUpdate();
        }
    }

    protected abstract void finishInitialization(@NotNull PhpInterpreter var1);

    @Override
    public void addListener(@NotNull Project project, @NotNull PhpInterpretersStateListener listener) {
        if (project == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(1);
        }
        if (listener == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(2);
        }
        ContainerUtil.add((Object)listener, this.myStateListeners, (Disposable)project);
    }

    @Override
    @NotNull
    public List<PhpInterpreter> getInterpreters() {
        ArrayList<PhpInterpreter> arrayList = new ArrayList<PhpInterpreter>(this.myInterpreters);
        if (arrayList == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public void setInterpreters(@NotNull List<PhpInterpreter> interpreters) {
        if (interpreters == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(4);
        }
        this.myInterpreters = new ArrayList<PhpInterpreter>(interpreters);
    }

    @Override
    public void addInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(5);
        }
        this.myInterpreters.add(interpreter);
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreter(@Nullable String interpreterName) {
        return interpreterName == null ? null : (PhpInterpreter)ContainerUtil.find(this.myInterpreters, interpreter -> interpreterName.equals(interpreter.getName()));
    }

    @Override
    @Nullable
    public String findInterpreterId(@Nullable String interpreterName) {
        PhpInterpreter interpreter = this.findInterpreter(interpreterName);
        return interpreter == null ? null : interpreter.getId();
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreterById(@Nullable String interpreterId) {
        if (StringUtil.isEmpty((String)interpreterId)) {
            return null;
        }
        return (PhpInterpreter)ContainerUtil.find(this.myInterpreters, interpreter -> interpreterId.equals(interpreter.getId()));
    }

    @Override
    @Nullable
    public PhpSdkAdditionalData findInterpreterDataById(@Nullable String interpreterId) {
        PhpInterpreter interpreter = this.findInterpreterById(interpreterId);
        return interpreter == null ? null : interpreter.getPhpSdkAdditionalData();
    }

    @Override
    @Nullable
    public String findInterpreterName(@Nullable String interpreterId) {
        PhpInterpreter interpreter = this.findInterpreterById(interpreterId);
        return interpreter == null ? null : interpreter.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersBaseManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = INTERPRETERS;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = INTERPRETER;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersBaseManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

