/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.frameworks.PhpFrameworkConfigurable;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.joomla.settings.JoomlaSettingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoomlaConfigurable
implements PhpFrameworkConfigurable {
    private JPanel myMainPanel;
    protected JBCheckBox myEnableJoomlaIntegrationJBCheckBox;
    private JPanel myJoomlaSettingsPlaceholder;
    private final JoomlaDataService myService;
    protected final JoomlaSettingsPanel mySettingsForm;

    public JoomlaConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myService = JoomlaDataService.getInstance(project);
        this.mySettingsForm = new JoomlaSettingsPanel(project, true, false);
        this.myJoomlaSettingsPlaceholder.add((Component)this.mySettingsForm.createMainPanel(), "Center");
        this.myEnableJoomlaIntegrationJBCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JoomlaConfigurable.this.updateSettingsPanelEnabled();
            }
        });
        this.updateSettingsPanelEnabled();
    }

    protected void updateSettingsPanelEnabled() {
        boolean selected = this.myEnableJoomlaIntegrationJBCheckBox.isSelected();
        UIUtil.setEnabled((Component)this.mySettingsForm.createMainPanel(), (boolean)selected, (boolean)true);
        this.mySettingsForm.setEnabled(selected);
    }

    @Nls
    public String getDisplayName() {
        return JoomlaBundle.message("joomla.title", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myService.isEnabled() != this.myEnableJoomlaIntegrationJBCheckBox.isSelected()) {
            return true;
        }
        return this.mySettingsForm.isModified(this.myService);
    }

    public void apply() throws ConfigurationException {
        JoomlaDataService.State state = new JoomlaDataService.State();
        state.setEnabled(this.myEnableJoomlaIntegrationJBCheckBox.isSelected());
        this.mySettingsForm.apply(state);
        this.myService.setState(state);
    }

    public void reset() {
        this.myEnableJoomlaIntegrationJBCheckBox.setSelected(this.myService.isEnabled());
        this.mySettingsForm.reset(this.myService);
        this.updateSettingsPanelEnabled();
    }

    public void disposeUIResources() {
    }

    @NotNull
    public String getId() {
        if ("php.joomla.base.configurable" == null) {
            JoomlaConfigurable.$$$reportNull$$$0(0);
        }
        return "php.joomla.base.configurable";
    }

    public boolean isBeingUsed() {
        return this.myEnableJoomlaIntegrationJBCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/joomla/settings/JoomlaConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableJoomlaIntegrationJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Enable Joomla! integration");
        jBCheckBox.setMnemonic('E');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myJoomlaSettingsPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

