/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.DockerSettings;
import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachineCommandException;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.docker.machine.DockerMachineNotStartedException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachine {
    private static final Logger LOG = Logger.getInstance(DockerMachine.class);
    private static final Pattern EXPORT_ENV_PATTERN = Pattern.compile("\\s*export\\s+([^=]+)=\"(.*)\"");
    private static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    private static final Set<String> DOCKER_OTHER_ENV_VARIABLES = Collections.singleton("DOCKER_MACHINE_NAME");
    private static final String PROTOCOL_QUALIFIER = "://";
    private static final String UNIX_FILE_SOCKET_PROTOCOL = "unix";
    private static final String ENV_COMMAND = "env";
    private static final String ENV_OPTION_SHELL = "--shell";
    public static final String BASH = "bash";
    private static final String LS_COMMAND = "ls";
    private static final String LS_OPTION_QUIET = "--quiet";
    private static final String IP_COMMAND = "ip";
    private static final String STATUS_COMMAND = "status";
    private static final String START_COMMAND = "start";
    private static final String VERSION_COMMAND = "--version";
    private static final int DEFAULT_TIMEOUT_IN_MILLIS_FOR_DOCKER_MACHINE = 30000;
    private static final int TIMEOUT_IN_MILLIS_FOR_START_COMMAND = 60000;
    private static final int TIMEOUT_IN_MILLIS_FOR_VERSION_COMMAND = 500;
    @NotNull
    private final String myDockerMachinePath;

    public static boolean hasDockerMachine() {
        return true;
    }

    public DockerMachine(@NotNull String dockerMachinePath) {
        if (dockerMachinePath == null) {
            DockerMachine.$$$reportNull$$$0(0);
        }
        this.myDockerMachinePath = dockerMachinePath;
    }

    @NotNull
    public static DockerMachine getDockerMachine(@NotNull String dockerMachinePath) {
        if (dockerMachinePath == null) {
            DockerMachine.$$$reportNull$$$0(1);
        }
        DockerMachine dockerMachine = new DockerMachine(dockerMachinePath);
        if (dockerMachine == null) {
            DockerMachine.$$$reportNull$$$0(2);
        }
        return dockerMachine;
    }

    @NotNull
    public static DockerMachine currentDockerMachine() {
        if (!DockerMachine.hasDockerMachine()) {
            throw new IllegalStateException();
        }
        DockerMachine dockerMachine = DockerMachine.getDockerMachine(DockerSettings.getInstance().getDockerMachinePath());
        if (dockerMachine == null) {
            DockerMachine.$$$reportNull$$$0(3);
        }
        return dockerMachine;
    }

    @NotNull
    public String getDockerMachinePath() {
        String string = this.myDockerMachinePath;
        if (string == null) {
            DockerMachine.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private ProcessOutput exec(@Nullable String machineName, @NotNull String[] command) throws DockerMachineException {
        if (command == null) {
            DockerMachine.$$$reportNull$$$0(5);
        }
        ProcessOutput processOutput = this.exec(machineName, command, 30000, false);
        if (processOutput == null) {
            DockerMachine.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    @NotNull
    private ProcessOutput exec(@Nullable String machineName, @NotNull String[] command, int timeoutInMillis, boolean cancellable) throws DockerMachineException {
        ProcessOutput processOutput;
        if (command == null) {
            DockerMachine.$$$reportNull$$$0(7);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine((String[])ArrayUtil.prepend((Object)this.myDockerMachinePath, (Object[])command));
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = cancellable && ProgressManager.getInstance().hasProgressIndicator() ? handler.runProcessWithProgressIndicator(ProgressManager.getInstance().getProgressIndicator()) : handler.runProcess(timeoutInMillis);
            if (output.isTimeout()) {
                throw new DockerMachineException("Timeout exceeded");
            }
            if (output.getExitCode() != 0) {
                if (machineName != null && DockerMachine.isDockerMachineNotStartedReason(output)) {
                    throw new DockerMachineNotStartedException(machineName, output.getExitCode(), output.getStderr());
                }
                throw new DockerMachineCommandException(output.getExitCode(), output.getStderr());
            }
            processOutput = output;
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrowUnchecked((Throwable)e.getCause());
            throw new DockerMachineException(e.getMessage(), e);
        }
        if (processOutput == null) {
            DockerMachine.$$$reportNull$$$0(8);
        }
        return processOutput;
    }

    private static boolean isDockerMachineNotStartedReason(@NotNull ProcessOutput output) {
        if (output == null) {
            DockerMachine.$$$reportNull$$$0(9);
        }
        return output.getStderr().contains(" is not running");
    }

    @NotNull
    public static DockerConnectionInfo parseStdout(@NotNull String stdout) {
        String urlProtocol;
        if (stdout == null) {
            DockerMachine.$$$reportNull$$$0(10);
        }
        Scanner scanner = new Scanner(stdout);
        Boolean tls = null;
        String dockerHost = null;
        String dockerCertPath = null;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            Pair<String, String> nameValue = DockerMachine.getExport(line);
            if (nameValue == null) continue;
            String name = (String)nameValue.first;
            String value = (String)nameValue.second;
            if (DOCKER_TLS_VERIFY.equals(name)) {
                tls = "1".equals(value);
                continue;
            }
            if (DOCKER_CERT_PATH.equals(name)) {
                dockerCertPath = value;
                continue;
            }
            if (DOCKER_HOST.equals(name)) {
                dockerHost = value;
                continue;
            }
            if (DOCKER_OTHER_ENV_VARIABLES.contains(name)) continue;
            LOG.debug("Docker Machine returned unknown environment variable: " + name + "=" + value);
        }
        if (dockerHost == null) {
            throw new IllegalStateException("DOCKER_HOST is not specified");
        }
        Pair<String, String> protocolAndHost = DockerMachine.splitToProtocolAndHost(dockerHost);
        String urlHost = (String)protocolAndHost.second;
        if (UNIX_FILE_SOCKET_PROTOCOL.equals(protocolAndHost.first)) {
            urlProtocol = UNIX_FILE_SOCKET_PROTOCOL;
            dockerCertPath = null;
        } else if (tls != null) {
            urlProtocol = tls != false ? "https" : "http";
        } else if (dockerCertPath == null) {
            LOG.info("Both DOCKER_TLS_VERIFY and DOCKER_CERT_PATH are not specified, TLS verification disabled");
            urlProtocol = "http";
        } else {
            LOG.info("DOCKER_TLS_VERIFY is not specified, TLS verification enabled");
            urlProtocol = "https";
        }
        String url = urlProtocol + PROTOCOL_QUALIFIER + urlHost;
        DockerConnectionInfo dockerConnectionInfo = new DockerConnectionInfo(url, dockerCertPath);
        if (dockerConnectionInfo == null) {
            DockerMachine.$$$reportNull$$$0(11);
        }
        return dockerConnectionInfo;
    }

    @NotNull
    private static Pair<String, String> splitToProtocolAndHost(@NotNull String dockerHost) {
        int i;
        if (dockerHost == null) {
            DockerMachine.$$$reportNull$$$0(12);
        }
        if ((i = dockerHost.indexOf(PROTOCOL_QUALIFIER)) != -1) {
            String protocol = dockerHost.substring(0, i);
            String host = dockerHost.substring(i + PROTOCOL_QUALIFIER.length());
            Pair pair = Pair.create((Object)protocol, (Object)host);
            if (pair == null) {
                DockerMachine.$$$reportNull$$$0(13);
            }
            return pair;
        }
        LOG.info("DOCKER_HOST is expected to contain protocol prefix but has nothing: " + dockerHost);
        Pair pair = Pair.create(null, (Object)dockerHost);
        if (pair == null) {
            DockerMachine.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @Nullable
    private static Pair<String, String> getExport(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            DockerMachine.$$$reportNull$$$0(15);
        }
        if ((matcher = EXPORT_ENV_PATTERN.matcher(line)).matches()) {
            return Pair.create((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    @NotNull
    public List<String> ls() throws DockerMachineException {
        List list = this.exec(null, new String[]{LS_COMMAND, LS_OPTION_QUIET}).getStdoutLines();
        if (list == null) {
            DockerMachine.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public DockerConnectionInfo env(@NotNull String shell, @NotNull String machineName) throws DockerMachineException {
        if (shell == null) {
            DockerMachine.$$$reportNull$$$0(17);
        }
        if (machineName == null) {
            DockerMachine.$$$reportNull$$$0(18);
        }
        DockerConnectionInfo dockerConnectionInfo = DockerMachine.parseStdout(this.exec(machineName, new String[]{ENV_COMMAND, ENV_OPTION_SHELL, shell, machineName}).getStdout());
        if (dockerConnectionInfo == null) {
            DockerMachine.$$$reportNull$$$0(19);
        }
        return dockerConnectionInfo;
    }

    @NotNull
    public String getMachineIp(@NotNull String machineName) {
        if (machineName == null) {
            DockerMachine.$$$reportNull$$$0(20);
        }
        ProcessOutput output = this.exec(machineName, new String[]{IP_COMMAND, machineName});
        String string = output.getStdout().trim();
        if (string == null) {
            DockerMachine.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public DockerConnectionInfo getDockerConnectionInfo(@NotNull String machineName) {
        if (machineName == null) {
            DockerMachine.$$$reportNull$$$0(22);
        }
        if (StringUtil.isEmpty((String)machineName)) {
            throw new IllegalArgumentException("Docker machine name must be provided");
        }
        DockerConnectionInfo dockerConnectionInfo = this.env(BASH, machineName);
        if (dockerConnectionInfo == null) {
            DockerMachine.$$$reportNull$$$0(23);
        }
        return dockerConnectionInfo;
    }

    @Nullable
    public String statusFor(@NotNull String machineName) {
        if (machineName == null) {
            DockerMachine.$$$reportNull$$$0(24);
        }
        String status = this.exec(machineName, new String[]{STATUS_COMMAND, machineName}).getStdout().trim();
        return StringUtil.nullize((String)status);
    }

    @NotNull
    public String version() {
        String string = this.exec(null, new String[]{VERSION_COMMAND}, 500, false).getStdout();
        if (string == null) {
            DockerMachine.$$$reportNull$$$0(25);
        }
        return string;
    }

    public void start(@NotNull String machineName) {
        if (machineName == null) {
            DockerMachine.$$$reportNull$$$0(26);
        }
        this.exec(machineName, new String[]{START_COMMAND, machineName}, 60000, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerMachinePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/machine/DockerMachine";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerHost";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shell";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/machine/DockerMachine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerMachine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "currentDockerMachine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerMachinePath";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStdout";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToProtocolAndHost";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = LS_COMMAND;
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = ENV_COMMAND;
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMachineIp";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerConnectionInfo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDockerMachine";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDockerMachineNotStartedReason";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseStdout";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "splitToProtocolAndHost";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExport";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = ENV_COMMAND;
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMachineIp";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDockerConnectionInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "statusFor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = START_COMMAND;
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

