/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.html.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("html" == null) {
            HtmlFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return "html";
    }

    public boolean acceptFile(VirtualFile file) {
        return HtmlUtil.isHtmlFile((VirtualFile)file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            HtmlFileIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)StdFileTypes.HTML);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile instanceof XmlFile) {
            FileIncludeInfo[] fileIncludeInfoArray = HtmlFileIncludeProvider.getIncludeInfos((XmlFile)psiFile);
            if (fileIncludeInfoArray == null) {
                HtmlFileIncludeProvider.$$$reportNull$$$0(2);
            }
            return fileIncludeInfoArray;
        }
        if (FileIncludeInfo.EMPTY == null) {
            HtmlFileIncludeProvider.$$$reportNull$$$0(3);
        }
        return FileIncludeInfo.EMPTY;
    }

    public static FileIncludeInfo[] getIncludeInfos(XmlFile xmlFile) {
        return (FileIncludeInfo[])HtmlUtil.getIncludedPathsElements((XmlFile)xmlFile).stream().filter(el -> el != null && !StringUtil.isEmptyOrSpaces((String)el.getValue())).map(el -> new FileIncludeInfo(el.getValue())).toArray(FileIncludeInfo[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/html/include/HtmlFileIncludeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/html/include/HtmlFileIncludeProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

