/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class FrameworkDescription {
    @NonNls
    public static final String FRAMEWORK = "framework";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VERSION = "version";
    @NonNls
    private static final String ALIAS = "alias";
    @NonNls
    private static final String INVOKE = "invoke";
    @NonNls
    private static final String ENABLED = "enabled";
    @NonNls
    private static final String FRAMEWORK_ID = "frameworkId";
    @NonNls
    private static final String EXTRA_DATA = "extraData";
    @NonNls
    private static final Namespace SCHEMA_NAMESPACE = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    @NonNls
    private static final String NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";
    private static final int CURRENT_VERSION = 2;
    private String myName;
    private String myInvokeText;
    private String myAlias;
    private String myHelp;
    private boolean isEnabled;
    private final String myFrameworkId;
    @Nullable
    private String myExtraData;

    public FrameworkDescription(@NotNull String name, @NonNls String invokeText, String alias, String help, boolean isEnabled, @Nullable String frameworkId, @Nullable String extraData) {
        if (name == null) {
            FrameworkDescription.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myInvokeText = invokeText;
        this.myAlias = alias;
        this.myHelp = FrameworkDescription.normalizeHelp(help);
        this.isEnabled = isEnabled;
        this.myFrameworkId = frameworkId;
        this.myExtraData = extraData;
    }

    public String getName() {
        return this.myName;
    }

    public String getInvokeText() {
        return this.myInvokeText;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getHelp() {
        return this.myHelp;
    }

    @Nullable
    public String getExtraData() {
        return this.myExtraData;
    }

    public String getFrameworkId() {
        return this.myFrameworkId;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setInvokeText(String invokeText) {
        this.myInvokeText = invokeText;
    }

    public void setAlias(String alias) {
        this.myAlias = alias;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setHelp(String help) {
        this.myHelp = FrameworkDescription.normalizeHelp(help);
    }

    public void setExtraData(@Nullable String extraData) {
        this.myExtraData = extraData;
    }

    public static String normalizeHelp(@NonNls String help) {
        return help == null ? "" : help.replaceAll("[ \\s]+", " ").trim();
    }

    public Document writeToDocument(List<FrameworkCommand> commands) {
        Element frameworkElement = new Element(FRAMEWORK);
        frameworkElement.addNamespaceDeclaration(SCHEMA_NAMESPACE);
        frameworkElement.setAttribute(NO_NAMESPACE_SCHEMA_LOCATION, "schemas/frameworkDescriptionVersion1.1.4.xsd", SCHEMA_NAMESPACE);
        if (!StringUtil.isEmpty((String)this.myFrameworkId)) {
            frameworkElement.setAttribute(FRAMEWORK_ID, this.myFrameworkId);
        }
        frameworkElement.setAttribute(NAME, this.myName);
        if (this.myInvokeText != null) {
            frameworkElement.setAttribute(INVOKE, this.myInvokeText);
        }
        if (this.myAlias != null) {
            frameworkElement.setAttribute(ALIAS, this.myAlias);
        }
        frameworkElement.setAttribute(ENABLED, String.valueOf(this.isEnabled));
        frameworkElement.setAttribute(VERSION, String.valueOf(2));
        if (!StringUtil.isEmpty((String)this.myExtraData)) {
            Element extraDataElement = new Element(EXTRA_DATA);
            extraDataElement.addContent((Content)new CDATA(this.myExtraData));
            frameworkElement.addContent(extraDataElement);
        }
        for (FrameworkCommand command : commands) {
            if (!command.belongsToFramework(this)) continue;
            frameworkElement.addContent(command.writeToElement());
        }
        FrameworkCommand.writeHelp(frameworkElement, this.myHelp);
        return new Document(frameworkElement, null, null);
    }

    @Nullable
    public static FrameworkDescription readFromElement(Element element, String fileName) throws SAXException {
        return (FrameworkDescription)FrameworkDescription.readFromElementWithVersion(element, fileName).getFirst();
    }

    private static Pair<FrameworkDescription, Integer> readFromElementWithVersion(Element element, @NonNls String fileName) throws SAXException {
        int version;
        boolean isEnabled;
        Attribute enabled;
        if (!FRAMEWORK.equals(element.getName())) {
            throw new SAXException(FrameworkBundle.message("framework.description.0.element.not.found", FRAMEWORK));
        }
        String name = element.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name)) {
            throw new SAXException(FrameworkBundle.message("framework.missing.required.non.empty.attribute.0.in.1.element", NAME, FRAMEWORK));
        }
        if (!fileName.equals(FrameworkDataService.getFileName(name = StringUtil.convertLineSeparators((String)name, (String)" ")))) {
            name = FrameworkDataService.getFrameworkNameFromFileName(fileName);
        }
        String frameworkId = element.getAttributeValue(FRAMEWORK_ID);
        Element extraDataElement = element.getChild(EXTRA_DATA);
        String extraData = null;
        if (extraDataElement != null) {
            for (Content child : extraDataElement.getContent()) {
                if (!(child instanceof CDATA)) continue;
                extraData = ((CDATA)child).getText();
                break;
            }
        }
        if ((enabled = element.getAttribute(ENABLED)) == null) {
            isEnabled = false;
        } else {
            try {
                isEnabled = enabled.getBooleanValue();
            }
            catch (DataConversionException e) {
                isEnabled = false;
            }
        }
        String invoke = element.getAttributeValue(INVOKE);
        if (StringUtil.isEmpty((String)invoke)) {
            isEnabled = false;
            invoke = "";
        } else {
            invoke = StringUtil.convertLineSeparators((String)invoke, (String)" ");
        }
        String alias = element.getAttributeValue(ALIAS);
        if (StringUtil.isEmpty((String)alias)) {
            isEnabled = false;
            alias = "";
        } else {
            alias = StringUtil.convertLineSeparators((String)alias, (String)" ");
        }
        String versionNumber = element.getAttributeValue(VERSION);
        if (StringUtil.isEmpty((String)versionNumber)) {
            versionNumber = "0";
        }
        try {
            version = Integer.parseInt(versionNumber);
        }
        catch (NumberFormatException e) {
            throw new SAXException(FrameworkBundle.message("framework.description.invalid.integer.value.of.attribute.0.of.element.1.2", VERSION, FRAMEWORK, versionNumber));
        }
        if (version < 0 || version > 2) {
            throw new SAXException(FrameworkBundle.message("framework.description.version.0.is.not.supported.yet", version));
        }
        if (version < 2) {
            frameworkId = FrameworkUtils.getFrameworkId(name);
        }
        String help = FrameworkCommand.readHelp(element);
        alias = StringUtil.convertLineSeparators((String)alias, (String)" ");
        FrameworkDescription frameworkDescription = new FrameworkDescription(name, invoke, alias, help, isEnabled, frameworkId, extraData);
        return Pair.create((Object)frameworkDescription, (Object)version);
    }

    public static List<FrameworkCommand> readCommandsFromElement(Element element, String fileName) throws SAXException {
        Pair<FrameworkDescription, Integer> frameworkPair = FrameworkDescription.readFromElementWithVersion(element, fileName);
        List parameterElements = element.getChildren("command");
        ArrayList<FrameworkCommand> commandList = new ArrayList<FrameworkCommand>(parameterElements.size());
        for (Element parameterElement : parameterElements) {
            FrameworkCommand command = FrameworkCommand.readFromElement(parameterElement, (FrameworkDescription)frameworkPair.getFirst(), (Integer)frameworkPair.getSecond());
            if (command == null) continue;
            commandList.add(command);
        }
        return commandList;
    }

    public FrameworkDescription cloneFramework() {
        return new FrameworkDescription(this.myName, this.myInvokeText, this.myAlias, this.myHelp, this.isEnabled, this.myFrameworkId, this.myExtraData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameworkDescription that = (FrameworkDescription)o;
        if (this.isEnabled != that.isEnabled) {
            return false;
        }
        if (this.myAlias != null ? !this.myAlias.equals(that.myAlias) : that.myAlias != null) {
            return false;
        }
        if (this.myHelp != null ? !this.myHelp.equals(that.myHelp) : that.myHelp != null) {
            return false;
        }
        if (this.myInvokeText != null ? !this.myInvokeText.equals(that.myInvokeText) : that.myInvokeText != null) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return !(this.myExtraData != null ? !this.myExtraData.equals(that.myExtraData) : that.myExtraData != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myInvokeText != null ? this.myInvokeText.hashCode() : 0);
        result = 31 * result + (this.myAlias != null ? this.myAlias.hashCode() : 0);
        result = 31 * result + (this.myHelp != null ? this.myHelp.hashCode() : 0);
        result = 31 * result + (this.isEnabled ? 1 : 0);
        result = 31 * result + (this.myExtraData != null ? this.myExtraData.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/jetbrains/php/framework/data/FrameworkDescription", "<init>"));
    }
}

