/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.jetbrains.annotations.NotNull;

public class ConvertToEntityFix
extends AbstractFix {
    private final XPathToken myToken;
    private final String myValue;

    public ConvertToEntityFix(XPathToken token) {
        this.myToken = token;
        this.myValue = this.myToken.getText().replaceAll("<", "&lt;");
    }

    @NotNull
    public String getText() {
        String string = "Convert '" + this.myToken.getText() + "' to '" + this.myValue + "'";
        if (string == null) {
            ConvertToEntityFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertToEntityFix.$$$reportNull$$$0(1);
        }
        if (!this.myToken.isValid()) {
            return false;
        }
        PsiFile psiFile = this.myToken.getContainingFile();
        assert (psiFile != null);
        PsiElement context = psiFile.getContext();
        return context != null && context.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ConvertToEntityFix.$$$reportNull$$$0(2);
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)this.myToken.getContainingFile(), XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myToken.getLanguage());
        assert (parserDefinition != null);
        XPathFile f = XPathChangeUtil.createXPathFile(this.myToken, "1 " + this.myValue + " 2");
        PsiElement firstChild = f.getFirstChild();
        assert (firstChild != null);
        XPathToken child = (XPathToken)PsiTreeUtil.getChildOfType((PsiElement)firstChild, XPathToken.class);
        assert (child != null);
        this.myToken.replace(child);
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

