/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.Cvs2Configurable;
import com.intellij.cvsSupport2.CvsDiffProvider;
import com.intellij.cvsSupport2.CvsRevisionSelector;
import com.intellij.cvsSupport2.CvsStandardOperationsProvider;
import com.intellij.cvsSupport2.CvsStatusEnvironment;
import com.intellij.cvsSupport2.CvsUpdateEnvironment;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.CvsMergeProvider;
import com.intellij.cvsSupport2.annotate.CvsAnnotationProvider;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsStorageSupportingDeletionComponent;
import com.intellij.cvsSupport2.changeBrowser.CvsChangeList;
import com.intellij.cvsSupport2.changeBrowser.CvsCommittedChangesProvider;
import com.intellij.cvsSupport2.checkinProject.CvsCheckinEnvironment;
import com.intellij.cvsSupport2.checkinProject.CvsRollbackEnvironment;
import com.intellij.cvsSupport2.checkout.CvsCheckoutProvider;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.FindAllRootsHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui.EditOptionsDialog;
import com.intellij.cvsSupport2.cvsstatuses.CvsChangeProvider;
import com.intellij.cvsSupport2.cvsstatuses.CvsEntriesListener;
import com.intellij.cvsSupport2.history.CvsHistoryProvider;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsVcs2
extends AbstractVcs<CvsChangeList>
implements TransactionProvider,
EditFileProvider {
    private static final String NAME = "CVS";
    private static final VcsKey ourKey = CvsVcs2.createKey((String)"CVS");
    private final Cvs2Configurable myConfigurable;
    private final CvsHistoryProvider myCvsHistoryProvider;
    private final CvsCheckinEnvironment myCvsCheckinEnvironment;
    private final CvsCheckoutProvider myCvsCheckoutProvider;
    private RollbackEnvironment myCvsRollbackEnvironment;
    private final CvsStandardOperationsProvider myCvsStandardOperationsProvider;
    private final CvsUpdateEnvironment myCvsUpdateEnvironment;
    private final CvsStatusEnvironment myCvsStatusEnvironment;
    private final CvsAnnotationProvider myCvsAnnotationProvider;
    private final CvsDiffProvider myDiffProvider;
    private final CvsCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myAddOptions;
    private final VcsShowSettingOption myRemoveOptions;
    private final VcsShowSettingOption myCheckoutOptions;
    private final VcsShowSettingOption myEditOption;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myRemoveConfirmation;
    private final CvsEntriesListener myCvsEntriesListener;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;

    public CvsVcs2(@NotNull Project project) {
        if (project == null) {
            CvsVcs2.$$$reportNull$$$0(0);
        }
        super(project, NAME);
        this.myCvsHistoryProvider = new CvsHistoryProvider(project);
        this.myCvsCheckinEnvironment = new CvsCheckinEnvironment(this.getProject());
        this.myCvsCheckoutProvider = new CvsCheckoutProvider();
        this.myCvsStandardOperationsProvider = new CvsStandardOperationsProvider(project);
        this.myCvsUpdateEnvironment = new CvsUpdateEnvironment(project);
        this.myCvsStatusEnvironment = new CvsStatusEnvironment(this.myProject);
        this.myConfigurable = new Cvs2Configurable(this.getProject());
        this.myCvsAnnotationProvider = new CvsAnnotationProvider(this.myProject, this.myCvsHistoryProvider);
        this.myDiffProvider = new CvsDiffProvider(this.myProject);
        this.myCommittedChangesProvider = new CvsCommittedChangesProvider(this.myProject);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myAddOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.ADD, (AbstractVcs)this);
        this.myRemoveOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.ADD, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        this.myEditOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.EDIT, (AbstractVcs)this);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myRemoveConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCvsEntriesListener = new CvsEntriesListener(){

            @Override
            public void entriesChanged(VirtualFile parent) {
                VirtualFile[] children = parent.getChildren();
                if (children == null) {
                    return;
                }
                for (VirtualFile child : children) {
                    CvsVcs2.this.fireFileStatusChanged(child);
                }
                VcsDirtyScopeManager.getInstance((Project)CvsVcs2.this.getProject()).fileDirty(parent);
            }

            @Override
            public void entryChanged(VirtualFile file) {
                if (CvsVcs2.this.myProject.isDisposed()) {
                    return;
                }
                CvsVcs2.this.fireFileStatusChanged(file);
                VcsDirtyScopeManager.getInstance((Project)CvsVcs2.this.getProject()).fileDirty(file);
            }
        };
    }

    @NotNull
    public String getDisplayName() {
        String string = CvsBundle.getCvsDisplayName();
        if (string == null) {
            CvsVcs2.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public TransactionProvider getTransactionProvider() {
        return this;
    }

    public void startTransaction(Object parameters) {
        this.myCvsStandardOperationsProvider.createTransaction();
    }

    public void commitTransaction(Object parameters) throws VcsException {
        this.myCvsStandardOperationsProvider.commit(parameters);
    }

    public void rollbackTransaction(Object parameters) {
        this.myCvsStandardOperationsProvider.rollback();
    }

    public CvsStandardOperationsProvider getStandardOperationsProvider() {
        return this.myCvsStandardOperationsProvider;
    }

    public static CvsVcs2 getInstance(Project project) {
        return (CvsVcs2)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    public int getFilesToProcessCount() {
        return this.myCvsStandardOperationsProvider.getFilesToProcessCount();
    }

    public static void executeOperation(String title, CvsOperation operation, Project project) throws VcsException {
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(new CommandCvsHandler(title, operation), CvsOperationExecutorCallback.EMPTY);
        CvsResult result = executor.getResult();
        if (result.hasErrors()) {
            throw result.composeError();
        }
    }

    public static CvsOperationExecutor executeQuietOperation(String title, CvsOperation operation, Project project) {
        CvsOperationExecutor executor = new CvsOperationExecutor(false, project, ModalityState.defaultModalityState());
        executor.setIsQuietOperation(true);
        executor.performActionSync(new CommandCvsHandler(title, operation), CvsOperationExecutorCallback.EMPTY);
        return executor;
    }

    public VcsShowSettingOption getAddOptions() {
        return this.myAddOptions;
    }

    public VcsShowSettingOption getRemoveOptions() {
        return this.myRemoveOptions;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        return this;
    }

    public void editFiles(VirtualFile[] files) {
        EditOptionsDialog editOptionsDialog;
        if (this.getEditOptions().getValue() && !(editOptionsDialog = new EditOptionsDialog(this.myProject)).showAndGet()) {
            return;
        }
        CvsHandler editHandler = CommandCvsHandler.createEditHandler(files, CvsConfiguration.getInstance((Project)this.myProject).RESERVED_EDIT);
        new CvsOperationExecutor(true, this.myProject, ModalityState.current()).performActionSync(editHandler, CvsOperationExecutorCallback.EMPTY);
    }

    public String getRequestText() {
        return CvsBundle.message((String)"message.text.edit.file.request", (Object[])new Object[0]);
    }

    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new CvsChangeProvider(this, CvsEntriesManager.getInstance());
        }
        return this.myChangeProvider;
    }

    protected void activate() {
        CvsStorageSupportingDeletionComponent.getInstance(this.myProject).init(this.getProject());
        CvsEntriesManager.getInstance().addCvsEntriesListener(this.myCvsEntriesListener);
    }

    protected void deactivate() {
        CvsStorageSupportingDeletionComponent.getInstance(this.myProject).deactivate();
        CvsEntriesManager.getInstance().removeCvsEntriesListener(this.myCvsEntriesListener);
    }

    private void fireFileStatusChanged(VirtualFile file) {
        FileStatusManager.getInstance((Project)this.getProject()).fileStatusChanged(file);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        CvsCheckinEnvironment cvsCheckinEnvironment = this.myCvsCheckinEnvironment;
        if (cvsCheckinEnvironment == null) {
            CvsVcs2.$$$reportNull$$$0(2);
        }
        return cvsCheckinEnvironment;
    }

    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myCvsRollbackEnvironment == null) {
            this.myCvsRollbackEnvironment = new CvsRollbackEnvironment(this.myProject);
        }
        return this.myCvsRollbackEnvironment;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.myCvsHistoryProvider;
    }

    @NotNull
    public VcsHistoryProvider getVcsHistoryProvider() {
        CvsHistoryProvider cvsHistoryProvider = this.myCvsHistoryProvider;
        if (cvsHistoryProvider == null) {
            CvsVcs2.$$$reportNull$$$0(3);
        }
        return cvsHistoryProvider;
    }

    public String getMenuItemText() {
        return CvsBundle.message((String)"menu.text.cvsGroup", (Object[])new Object[0]);
    }

    public UpdateEnvironment createUpdateEnvironment() {
        return this.myCvsUpdateEnvironment;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return CvsUtil.fileIsUnderCvs(filePath.getIOFile());
    }

    public boolean fileExistsInVcs(FilePath path) {
        return CvsUtil.fileExistsInCvs(path);
    }

    public UpdateEnvironment getStatusEnvironment() {
        return this.myCvsStatusEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.myCvsAnnotationProvider;
    }

    public FileAnnotation createAnnotation(VirtualFile cvsVirtualFile, String revision, CvsEnvironment environment) throws VcsException {
        return this.myCvsAnnotationProvider.annotate(cvsVirtualFile, revision, environment);
    }

    public DiffProvider getDiffProvider() {
        return this.myDiffProvider;
    }

    public VcsShowSettingOption getEditOptions() {
        return this.myEditOption;
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getRemoveConfirmation() {
        return this.myRemoveConfirmation;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return new CvsRevisionSelector(this.myProject);
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return new CvsRevisionNumber(revisionNumberString);
    }

    public String getRevisionPattern() {
        return "\\d+(\\.\\d+)*";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        VirtualFile child = dir.findChild(NAME);
        return child != null && child.isDirectory();
    }

    public CvsCheckoutProvider getCheckoutProvider() {
        return this.myCvsCheckoutProvider;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return new AbstractVcs.RootsConvertor(){

            @NotNull
            public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                List<VirtualFile> list = FindAllRootsHelper.findVersionedUnder(result);
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/cvsSupport2/CvsVcs2$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/cvsSupport2/CvsVcs2$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertRoots";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider != null) {
            this.myMergeProvider = new CvsMergeProvider();
        }
        return this.myMergeProvider;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    @NotNull
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        if (in == null) {
            CvsVcs2.$$$reportNull$$$0(4);
        }
        if (convertor == null) {
            CvsVcs2.$$$reportNull$$$0(5);
        }
        List<S> list = in;
        if (list == null) {
            CvsVcs2.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cvsSupport2/CvsVcs2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cvsSupport2/CvsVcs2";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckinEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsHistoryProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

