/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBFederatedProvider;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFederatedProvider;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFederatedProvider;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFederatedProvider;
import org.jetbrains.dekaf.util.Providers;

public class BaseFederatedProvider
implements DBFederatedProvider {
    @Nullable
    private IntegralIntermediateFederatedProvider myIntermediateProvider;

    public void initLocally() {
        this.myIntermediateProvider = Providers.loadProvider(IntegralIntermediateFederatedProvider.class);
    }

    public void initRemotely(@NotNull PrimeIntermediateFederatedProvider remoteProvider) {
        this.myIntermediateProvider = new AdaptIntermediateFederatedProvider(remoteProvider);
    }

    @Override
    @NotNull
    public synchronized Set<Rdbms> supportedRdbms() {
        if (this.myIntermediateProvider != null) {
            return this.myIntermediateProvider.supportedRdbms();
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public synchronized DBFacade openFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, boolean connect) {
        if (this.myIntermediateProvider != null) {
            boolean ok = false;
            IntegralIntermediateFacade intermediateFacade = this.myIntermediateProvider.openFacade(connectionString, connectionProperties, connectionsLimit);
            try {
                BaseFacade facade = new BaseFacade(intermediateFacade);
                if (connect) {
                    facade.connect();
                }
                ok = true;
                BaseFacade baseFacade = facade;
                return baseFacade;
            }
            finally {
                if (!ok) {
                    intermediateFacade.disconnect();
                }
            }
        }
        throw new IllegalStateException("The federated provider is not initialized yet");
    }
}

