/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class XmlTagValueImpl
implements XmlTagValue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlTagValueImpl");
    private final XmlTag myTag;
    private final XmlTagChild[] myElements;
    private volatile XmlText[] myTextElements;
    private volatile String myText;
    private volatile String myTrimmedText;

    public XmlTagValueImpl(@NotNull XmlTagChild[] bodyElements, @NotNull XmlTag tag) {
        if (bodyElements == null) {
            XmlTagValueImpl.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            XmlTagValueImpl.$$$reportNull$$$0(1);
        }
        this.myTag = tag;
        this.myElements = bodyElements;
    }

    @NotNull
    public XmlTagChild[] getChildren() {
        if (this.myElements == null) {
            XmlTagValueImpl.$$$reportNull$$$0(2);
        }
        return this.myElements;
    }

    @NotNull
    public XmlText[] getTextElements() {
        XmlText[] textElements = this.myTextElements;
        if (textElements == null) {
            textElements = (XmlText[])Arrays.stream(this.myElements).filter(element -> element instanceof XmlText).map(element -> (XmlText)element).toArray(XmlText[]::new);
            textElements = textElements.length == 0 ? XmlText.EMPTY_ARRAY : textElements;
            this.myTextElements = textElements;
        }
        if (textElements == null) {
            XmlTagValueImpl.$$$reportNull$$$0(3);
        }
        return textElements;
    }

    @NotNull
    public String getText() {
        String text = this.myText;
        if (text == null) {
            StringBuilder consolidatedText = new StringBuilder();
            for (XmlTagChild element : this.myElements) {
                consolidatedText.append(element.getText());
            }
            this.myText = text = consolidatedText.toString();
        }
        String string = text;
        if (string == null) {
            XmlTagValueImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myElements.length == 0) {
            ASTNode child2 = XmlChildRole.START_TAG_END_FINDER.findChild((ASTNode)this.myTag);
            if (child2 != null) {
                TextRange textRange = new TextRange(child2.getStartOffset() + 1, child2.getStartOffset() + 1);
                if (textRange == null) {
                    XmlTagValueImpl.$$$reportNull$$$0(5);
                }
                return textRange;
            }
            TextRange textRange = new TextRange(this.myTag.getTextRange().getEndOffset(), this.myTag.getTextRange().getEndOffset());
            if (textRange == null) {
                XmlTagValueImpl.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        TextRange textRange = new TextRange(this.myElements[0].getTextRange().getStartOffset(), this.myElements[this.myElements.length - 1].getTextRange().getEndOffset());
        if (textRange == null) {
            XmlTagValueImpl.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public String getTrimmedText() {
        String trimmedText = this.myTrimmedText;
        if (trimmedText == null) {
            XmlText[] textElements;
            StringBuilder consolidatedText = new StringBuilder();
            for (XmlText textElement : textElements = this.getTextElements()) {
                consolidatedText.append(textElement.getValue());
            }
            this.myTrimmedText = trimmedText = consolidatedText.toString().trim();
        }
        String string = trimmedText;
        if (string == null) {
            XmlTagValueImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setText(String value) {
        this.setText(value, false);
    }

    public void setEscapedText(String value) {
        this.setText(value, true);
    }

    private void setText(String value, boolean defaultPolicy) {
        try {
            XmlText text = null;
            if (value != null) {
                XmlText[] texts = this.getTextElements();
                text = texts.length == 0 ? (XmlText)this.myTag.add((PsiElement)XmlElementFactory.getInstance((Project)this.myTag.getProject()).createDisplayText("x")) : texts[0];
                if (StringUtil.isEmpty((String)value)) {
                    text.delete();
                } else if (defaultPolicy && text instanceof XmlTextImpl) {
                    ((XmlTextImpl)text).doSetValue(value, new DefaultXmlPsiPolicy());
                } else {
                    text.setValue(value);
                }
            }
            if (this.myElements.length > 0) {
                for (XmlTagChild child2 : this.myElements) {
                    if (child2 == text) continue;
                    child2.delete();
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean hasCDATA() {
        for (XmlText xmlText : this.getTextElements()) {
            PsiElement[] children2;
            for (PsiElement child2 : children2 = xmlText.getChildren()) {
                if (child2.getNode().getElementType() != XmlElementType.XML_CDATA) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlTagValue createXmlTagValue(XmlTag tag) {
        final ArrayList bodyElements = new ArrayList();
        tag.processElements(new PsiElementProcessor(){
            boolean insideBody;

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ASTNode treeElement = element.getNode();
                if (this.insideBody) {
                    if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_END_TAG_START) {
                        return false;
                    }
                    if (!(element instanceof XmlTagChild)) {
                        return true;
                    }
                    bodyElements.add((XmlTagChild)element);
                } else if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_TAG_END) {
                    this.insideBody = true;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagValueImpl$1", "execute"));
            }
        }, (PsiElement)tag);
        XmlTagChild[] tagChildren = bodyElements.toArray(XmlTagChild.EMPTY_ARRAY);
        return new XmlTagValueImpl(tagChildren, tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlTagValueImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlTagValueImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

