/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectAndAdjustIndentOptionsTask;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private static final ExecutorService BOUNDED_EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DetectableIndentOptionsProvider Pool");
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Automatic indent detection", NotificationDisplayType.STICKY_BALLOON, true);
    private boolean myIsEnabledInTest;
    private final Map<VirtualFile, CommonCodeStyleSettings.IndentOptions> myDiscardedOptions = ContainerUtil.createWeakMap();
    private boolean hasBeenAdvertised;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        TimeStampedIndentOptions options;
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if (!this.isEnabled(settings, file2)) {
            return null;
        }
        Project project = file2.getProject();
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project);
        Document document = psiManager.getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        synchronized (document2) {
            options = this.getValidCachedIndentOptions(file2, document);
            if (options != null) {
                return options;
            }
            options = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document);
            options.associateWithDocument(document);
        }
        this.scheduleDetectionInBackground(project, document, options);
        return options;
    }

    protected void scheduleDetectionInBackground(@NotNull Project project, @NotNull Document document, @NotNull TimeStampedIndentOptions options) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        if (document == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        if (options == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        DetectAndAdjustIndentOptionsTask task = new DetectAndAdjustIndentOptionsTask(project, document, options, BOUNDED_EXECUTOR);
        task.scheduleInBackgroundForCommittedDocument();
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(6);
        }
        if (!file2.isWritable() || file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledFile || file2.getFileType() == ScratchFileType.INSTANCE) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile || this.myDiscardedOptions.containsKey(vFile)) {
            return false;
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null && settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    @Nullable
    public AnAction[] getActions(@NotNull PsiFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(7);
        }
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(8);
        }
        ArrayList actions = ContainerUtil.newArrayList();
        VirtualFile virtualFile = file2.getVirtualFile();
        Project project = file2.getProject();
        CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)project).getIndentOptions(file2.getFileType());
        String projectOptionsTip = StringUtil.capitalizeWords((String)FileIndentOptionsProvider.getTooltip((CommonCodeStyleSettings.IndentOptions)projectOptions, null), (boolean)true);
        if (indentOptions instanceof TimeStampedIndentOptions) {
            if (((TimeStampedIndentOptions)indentOptions).isDetected()) {
                actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reject", (Object[])new Object[]{projectOptionsTip}), e -> {
                    if (indentOptions == null) {
                        DetectableIndentOptionsProvider.$$$reportNull$$$0(27);
                    }
                    if (file2 == null) {
                        DetectableIndentOptionsProvider.$$$reportNull$$$0(28);
                    }
                    this.disableForFile(virtualFile, indentOptions);
                    DetectableIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                }));
                actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reindent", (Object[])new Object[]{projectOptionsTip}), e -> {
                    if (indentOptions == null) {
                        DetectableIndentOptionsProvider.$$$reportNull$$$0(23);
                    }
                    if (file2 == null) {
                        DetectableIndentOptionsProvider.$$$reportNull$$$0(24);
                    }
                    this.disableForFile(virtualFile, indentOptions);
                    DetectableIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                        if (file2 == null) {
                            DetectableIndentOptionsProvider.$$$reportNull$$$0(25);
                        }
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            if (file2 == null) {
                                DetectableIndentOptionsProvider.$$$reportNull$$$0(26);
                            }
                            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, file2.getTextRange());
                        });
                    });
                    this.myDiscardedOptions.remove(virtualFile);
                }));
                actions.add(Separator.getInstance());
            }
        } else if (this.myDiscardedOptions.containsKey(virtualFile)) {
            CommonCodeStyleSettings.IndentOptions discardedOptions = this.myDiscardedOptions.get(virtualFile);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
            if (document != null) {
                actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.apply", (Object[])new Object[]{DetectableIndentOptionsProvider.getTooltip((CommonCodeStyleSettings.IndentOptions)discardedOptions, null), ColorUtil.toHex((Color)JBColor.GRAY)}), e -> {
                    if (file2 == null) {
                        DetectableIndentOptionsProvider.$$$reportNull$$$0(22);
                    }
                    this.myDiscardedOptions.remove(virtualFile);
                    discardedOptions.associateWithDocument(document);
                    DetectableIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                }));
                actions.add(Separator.getInstance());
            }
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(9);
        }
        return DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.disable", (Object[])new Object[0]), e -> {
            if (project == null) {
                DetectableIndentOptionsProvider.$$$reportNull$$$0(21);
            }
            CodeStyle.getSettings((Project)project).AUTODETECT_INDENTS = false;
            this.myDiscardedOptions.clear();
            DetectableIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, null);
            DetectableIndentOptionsProvider.showDisabledDetectionNotification(project);
        });
    }

    private void disableForFile(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(10);
        }
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(11);
        }
        this.myDiscardedOptions.put(file2, indentOptions);
    }

    public TimeStampedIndentOptions getValidCachedIndentOptions(PsiFile file2, Document document) {
        TimeStampedIndentOptions defaultIndentOptions;
        TimeStampedIndentOptions cachedInDocument;
        CommonCodeStyleSettings.IndentOptions options = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument((PsiFile)file2);
        if (options instanceof TimeStampedIndentOptions && !(cachedInDocument = (TimeStampedIndentOptions)options).isOutdated(document, defaultIndentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document))) {
            return cachedInDocument;
        }
        return null;
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(12);
        }
        DetectionDisabledNotification notification = new DetectionDisabledNotification(project);
        notification.notify(project);
    }

    public String getHint(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(13);
        }
        if (DetectableIndentOptionsProvider.areDetected(indentOptions)) {
            return "detected";
        }
        return null;
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(14);
        }
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(15);
        }
        return DetectableIndentOptionsProvider.areDetected(indentOptions) || this.myDiscardedOptions.containsKey(file2);
    }

    @Nullable
    public String getAdvertisementText(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (psiFile == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(16);
        }
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(17);
        }
        if (DetectableIndentOptionsProvider.areDetected(indentOptions) && !this.hasBeenAdvertised) {
            String actualOptionsHint = DetectableIndentOptionsProvider.getTooltip((CommonCodeStyleSettings.IndentOptions)indentOptions, null);
            CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)psiFile.getProject()).getIndentOptions(psiFile.getFileType());
            String projectOptionsHint = DetectableIndentOptionsProvider.getTooltip((CommonCodeStyleSettings.IndentOptions)projectOptions, null);
            this.hasBeenAdvertised = true;
            return ApplicationBundle.message((String)"code.style.different.indent.size.detected", (Object[])new Object[]{actualOptionsHint, projectOptionsHint});
        }
        return null;
    }

    private static boolean areDetected(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(18);
        }
        return indentOptions instanceof TimeStampedIndentOptions && ((TimeStampedIndentOptions)indentOptions).isDetected();
    }

    @Nullable
    public AnAction createDefaultAction(@NotNull Project project) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(19);
        }
        return !CodeStyle.getSettings((Project)project).AUTODETECT_INDENTS ? DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.enable", (Object[])new Object[0]), e -> {
            if (project == null) {
                DetectableIndentOptionsProvider.$$$reportNull$$$0(20);
            }
            CodeStyle.getSettings((Project)project).AUTODETECT_INDENTS = true;
            DetectableIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, null);
        }) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleDetectionInBackground";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDisableAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showDisabledDetectionNotification";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "areActionsAvailable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdvertisementText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "areDetected";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createDefaultAction$6";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createDisableAction$5";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getActions$4";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getActions$3";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getActions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReEnableDetection
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableDetection(@NotNull Project project, Notification notification) {
            if (project == null) {
                ReEnableDetection.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReEnableDetection.$$$reportNull$$$0(1);
            }
            CodeStyle.getSettings((Project)this.myProject).AUTODETECT_INDENTS = true;
            FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)this.myProject, null);
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$ReEnableDetection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowIndentDetectionOptionAction
    extends DumbAwareAction {
        private ShowIndentDetectionOptionAction(@Nullable String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowIndentDetectionOptionAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtilImpl.showSettingsDialog(e.getProject(), "preferences.sourceCode", "detect indent");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$ShowIndentDetectionOptionAction", "actionPerformed"));
        }
    }

    private static class DetectionDisabledNotification
    extends Notification {
        private DetectionDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message((String)"code.style.indent.detector.notification.content", (Object[])new Object[0]), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableDetection(project, this));
            this.addAction((AnAction)new ShowIndentDetectionOptionAction(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }
}

