/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeActionGroup
extends ActionGroup {
    private final MergeOperations myOperations;

    public MergeActionGroup(DiffPanelImpl diffPanel, FragmentSide side) {
        this.myOperations = new MergeOperations(diffPanel, side);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        List<MergeOperations.Operation> operations = this.myOperations.getOperations();
        AnAction[] actions = new AnAction[operations.size() + 2];
        actions[0] = new SelectSuggestionAction(this.myOperations);
        actions[1] = Separator.getInstance();
        for (int i = 2; i < actions.length; ++i) {
            actions[i] = new OperationAction(operations.get(i - 2));
        }
        if (actions == null) {
            MergeActionGroup.$$$reportNull$$$0(0);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/MergeActionGroup", "getChildren"));
    }

    public static class OperationAction
    extends DumbAwareAction {
        private final MergeOperations.Operation myOperation;

        public OperationAction(MergeOperations.Operation operation) {
            super(operation.getName(), null, operation.getGutterIcon());
            this.myOperation = operation;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                OperationAction.$$$reportNull$$$0(0);
            }
            this.myOperation.perform(e.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/actions/MergeActionGroup$OperationAction", "actionPerformed"));
        }
    }

    private static class SelectSuggestionAction
    extends AnAction {
        private final MergeOperations myOperations;

        SelectSuggestionAction(MergeOperations operations) {
            super(DiffBundle.message((String)"diff.dialog.select.change.action.name", (Object[])new Object[0]), DiffBundle.message((String)"diff.dialog.select.change.action.description", (Object[])new Object[0]), null);
            this.myOperations = operations;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectSuggestionAction.$$$reportNull$$$0(0);
            }
            this.myOperations.selectSuggestion();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectSuggestionAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myOperations.getCurrentFragment() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/diff/actions/MergeActionGroup$SelectSuggestionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

