/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public interface TestSearchScope {
    public static final TestSearchScope WHOLE_PROJECT = new TestSearchScope(){

        @Override
        public SourceScope getSourceScope(ModuleBasedConfiguration configuration) {
            return SourceScope.wholeProject(configuration.getProject());
        }

        public String toString() {
            return "WHOLE_PROJECT";
        }
    };
    public static final TestSearchScope SINGLE_MODULE = new TestSearchScope(){

        @Override
        public SourceScope getSourceScope(ModuleBasedConfiguration configuration) {
            return SourceScope.modules(configuration.getModules());
        }

        public String toString() {
            return "SINGLE_MODULE";
        }
    };
    public static final TestSearchScope MODULE_WITH_DEPENDENCIES = new TestSearchScope(){

        @Override
        public SourceScope getSourceScope(ModuleBasedConfiguration configuration) {
            return SourceScope.modulesWithDependencies(configuration.getModules());
        }

        public String toString() {
            return "MODULE_WITH_DEPENDENCIES";
        }
    };

    @Nullable
    public SourceScope getSourceScope(ModuleBasedConfiguration var1);

    public static class Wrapper
    implements JDOMExternalizable {
        @NonNls
        private static final String DEFAULT_NAME = "defaultName";
        private TestSearchScope myScope = SINGLE_MODULE;
        @NonNls
        private static final String WHOLE_PROJECT_NAE = "wholeProject";
        @NonNls
        private static final String SINGLE_MODULE_NAME = "singleModule";
        @NonNls
        private static final String MODULE_WITH_DEPENDENCIES_NAME = "moduleWithDependencies";

        public void readExternal(Element element) throws InvalidDataException {
            String value = element.getAttributeValue(DEFAULT_NAME);
            this.myScope = SINGLE_MODULE_NAME.equals(value) ? SINGLE_MODULE : (MODULE_WITH_DEPENDENCIES_NAME.equals(value) ? MODULE_WITH_DEPENDENCIES : WHOLE_PROJECT);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            String name = WHOLE_PROJECT_NAE;
            if (this.myScope == SINGLE_MODULE) {
                name = SINGLE_MODULE_NAME;
            } else if (this.myScope == MODULE_WITH_DEPENDENCIES) {
                name = MODULE_WITH_DEPENDENCIES_NAME;
            }
            element.setAttribute(DEFAULT_NAME, name);
        }

        public TestSearchScope getScope() {
            return this.myScope;
        }

        public void setScope(TestSearchScope scope) {
            this.myScope = scope;
        }

        public String toString() {
            return this.myScope == null ? "null" : this.myScope.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Wrapper)) {
                return false;
            }
            Wrapper wrapper2 = (Wrapper)o;
            return Objects.equals(this.myScope, wrapper2.myScope);
        }

        public int hashCode() {
            return Objects.hash(this.myScope);
        }
    }
}

