/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.dialog;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.Nullable;

public class VcsScopeItem
implements ModelScopeItem {
    private static final String ALL = AnalysisScopeBundle.message((String)"scope.option.uncommitted.files.all.changelists.choice", (Object[])new Object[0]);
    private final ChangeListManager myChangeListManager;
    private final DefaultComboBoxModel<String> myModel;
    private final Project myProject;

    @Nullable
    public static VcsScopeItem createIfHasVCS(Project project) {
        if (ChangeListManager.getInstance((Project)project).getAffectedFiles().isEmpty()) {
            return null;
        }
        return new VcsScopeItem(project);
    }

    private VcsScopeItem(Project project) {
        this.myProject = project;
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        assert (!this.myChangeListManager.getAffectedFiles().isEmpty());
        this.myModel = new DefaultComboBoxModel();
        this.myModel.addElement(ALL);
        List changeLists = this.myChangeListManager.getChangeListsCopy();
        for (ChangeList changeList : changeLists) {
            this.myModel.addElement(changeList.getName());
        }
    }

    @Override
    public AnalysisScope getScope() {
        Object selectedItem = this.myModel.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        List files2 = selectedItem == ALL ? this.myChangeListManager.getAffectedFiles() : this.myChangeListManager.getChangeListsCopy().stream().filter(l -> Comparing.strEqual((String)l.getName(), (String)((String)selectedItem))).flatMap(l -> ChangesUtil.getAfterRevisionsFiles(l.getChanges().stream())).collect(Collectors.toList());
        return new AnalysisScope(this.myProject, new HashSet(files2));
    }

    public DefaultComboBoxModel<String> getChangeListsModel() {
        return this.myModel;
    }
}

