/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf;

import java.awt.Component;
import java.util.Iterator;
import org.igoweb.go.Game;
import org.igoweb.go.Loc;
import org.igoweb.go.Rules;
import org.igoweb.go.swing.Estimator;
import org.igoweb.go.swing.sgf.EstimateOutput;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Errout;
import yoshikawa.GobanInterface;
import yoshikawa.gorule;

public class YoshikawaEstimator
implements Estimator,
GobanInterface {
    @Override
    public void estimate(Game game, Component parent, String gameTitle) {
        AFrame output = null;
        try {
            int owner;
            Loc loc;
            gorule engine = this.computeEstimate(game);
            Rules rules = game.getRules();
            float finalEstimate = rules.getKomi() + (float)game.caps(1) - (float)game.caps(0);
            Iterator<Loc> locs = game.allLocs();
            while (locs.hasNext()) {
                loc = locs.next();
                owner = this.whoseTerritory(engine, loc);
                if (game.getColor(loc) == 2) {
                    if (owner == 0) {
                        finalEstimate -= 1.0f;
                        continue;
                    }
                    if (owner != 1) continue;
                    finalEstimate += 1.0f;
                    continue;
                }
                if (rules.isScoreCaptures()) {
                    if (owner == game.getColor(loc)) continue;
                    if (game.getColor(loc) == 0) {
                        finalEstimate += 2.0f;
                        continue;
                    }
                    finalEstimate -= 2.0f;
                    continue;
                }
                if (owner != game.getColor(loc)) continue;
                if (game.getColor(loc) == 0) {
                    finalEstimate -= 1.0f;
                    continue;
                }
                finalEstimate += 1.0f;
            }
            output = new EstimateOutput(game, parent, gameTitle, finalEstimate);
            locs = game.allLocs();
            while (locs.hasNext()) {
                loc = locs.next();
                owner = this.whoseTerritory(engine, loc);
                if (game.getColor(loc) == owner) continue;
                int mark = owner == 2 ? 128 : (owner == 0 ? 32 : 64);
                ((EstimateOutput)output).goban.getStoneWidget(loc).setMark(mark);
            }
        }
        catch (Exception excep) {
            if (output != null) {
                output.dispose();
            }
            new Errout(Defs.getString(1096335305), parent);
        }
    }

    private gorule computeEstimate(Game game) {
        gorule engine = new gorule(this);
        Iterator<Loc> locs = game.allLocs();
        while (locs.hasNext()) {
            Loc loc = locs.next();
            switch (game.getColor(loc)) {
                case 0: {
                    engine.PlaceStone(loc.x + 1, loc.y + 1, 1);
                    break;
                }
                case 1: {
                    engine.PlaceStone(loc.x + 1, loc.y + 1, 2);
                    break;
                }
            }
        }
        engine.SetTeban(game.getWhoseMove() == 0 ? 1 : 2);
        engine.setDispMode(false);
        engine.scoreCalculation();
        return engine;
    }

    protected int whoseTerritory(gorule engine, Loc loc) {
        char yoshiCode = engine.getScoreMap(loc.x + 1, loc.y + 1);
        switch (yoshiCode) {
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'R': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': {
                return 2;
            }
            case 'A': 
            case 'D': 
            case 'J': 
            case 'P': 
            case 'T': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'K': 
            case 'Q': 
            case 'U': {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public void display(int x, int y, int t, int s) {
    }

    @Override
    public boolean possible(Game game) {
        return game.size == 19;
    }
}

