/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.igoweb.go.swing.StoneImages;
import org.igoweb.util.Defs;

public class CapsWidget
extends JComponent {
    private final int color;
    private int numCaps = 0;
    private StoneImages images = null;
    private static final int BLANK_SZ = 2;
    private static final int NUM_OVERLAP = 3;
    private GlyphVector capsGV;
    private Rectangle2D capsBounds;

    public CapsWidget(int color) {
        this.color = color;
        this.setForeground(color == 0 ? Color.white : Color.black);
        this.setBackground(new Color(128, 128, 128));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setOpaque(true);
    }

    public void setCaps(int newVal) {
        if (newVal != this.numCaps) {
            this.numCaps = newVal;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        int numStones;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(this.getBackground().brighter());
        if (this.capsGV == null) {
            this.capsGV = this.getFont().createGlyphVector(g2d.getFontRenderContext(), Defs.getString(-451068506));
            this.capsBounds = this.capsGV.getOutline().getBounds2D();
        }
        g2d.drawGlyphVector(this.capsGV, (int)((double)this.getWidth() - (this.capsBounds.getMinX() + this.capsBounds.getMaxX())) / 2, (int)((double)this.getHeight() - (this.capsBounds.getMinY() + this.capsBounds.getMaxY())) / 2);
        g2d.setColor(this.getForeground());
        this.paintBorder(g2d);
        Insets insets = this.getInsets();
        if (this.images == null) {
            this.images = StoneImages.create(this.getHeight() - (insets.top + insets.bottom) + 4);
        }
        if ((numStones = this.numCaps) > 0) {
            String label = NumberFormat.getInstance().format(this.numCaps);
            int drawW = this.images.size * (numStones + 3 - 1) / 3;
            int widgetW = this.getWidth() - (insets.left + insets.right);
            if (drawW > widgetW && (numStones = (drawW = widgetW) * 3 / this.images.size - 2) < 1) {
                numStones = 1;
            }
            widgetW += insets.left + insets.right;
            g2d.translate(0, insets.top - 2);
            int oldX = 0;
            for (int i = 0; i < numStones; ++i) {
                int x = (widgetW - drawW) / 2 + i * drawW / (numStones + 3 - 1);
                g2d.translate(x - oldX, 0);
                oldX = x;
                this.images.paintStone(g2d, this.color, 0, StoneImages.whiteImageId(i), null, 0);
            }
            g2d.translate(-oldX, 2 - insets.top);
            GlyphVector gv = this.getFont().createGlyphVector(g2d.getFontRenderContext(), label);
            Rectangle2D bounds = gv.getOutline().getBounds2D();
            g2d.drawGlyphVector(gv, (int)((double)widgetW - (bounds.getMinX() + bounds.getMaxX())) / 2, (int)((double)this.getHeight() - (bounds.getMinY() + bounds.getMaxY())) / 2);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        FontRenderContext frc = g2d == null ? new FontRenderContext(new AffineTransform(), false, false) : g2d.getFontRenderContext();
        Rectangle2D textBounds = this.getFont().createGlyphVector(frc, NumberFormat.getInstance().format(999L)).getOutline().getBounds2D();
        if (this.capsGV == null) {
            this.capsGV = this.getFont().createGlyphVector(frc, Defs.getString(-451068506));
            this.capsBounds = this.capsGV.getOutline().getBounds2D();
        }
        double w = textBounds.getWidth();
        if (this.capsBounds.getWidth() > w) {
            w = this.capsBounds.getWidth();
        }
        double h = textBounds.getHeight();
        if (this.capsBounds.getHeight() > h) {
            h = this.capsBounds.getHeight();
        }
        Insets insets = this.getInsets();
        return new Dimension((int)Math.ceil(w) + insets.left + insets.right, (int)Math.ceil(h) + insets.top + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

