/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host.remote.model;

import java.io.IOException;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.ConnectException;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.model.HostOverview;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;

class RemoteHostOverview
extends HostOverview {
    private static final ObjectName osMXBeanName = RemoteHostOverview.getOperatingSystemMXBeanName();
    private static final String TotalPhysicalMemorySizeAttr = "TotalPhysicalMemorySize";
    private static final String TotalPhysicalMemorySizeAttr1 = "TotalPhysicalMemory";
    private static final String FreePhysicalMemorySizeAttr = "FreePhysicalMemorySize";
    private static final String TotalSwapSpaceSizeAttr = "TotalSwapSpaceSize";
    private static final String FreeSwapSpaceSizeAttr = "FreeSwapSpaceSize";
    private volatile OperatingSystemMXBean osMXBean;
    private volatile MBeanServerConnection connection;
    private volatile boolean loadAverageAvailable;
    private volatile Application jmxApp;
    private String totalPhysicalMemorySizeAttr;
    private Host remoteHost;
    private boolean staticDataInitialized;
    private String name;
    private String version;
    private String patchLevel;
    private String arch;

    RemoteHostOverview(Host h) {
        this.remoteHost = h;
    }

    public String getName() {
        this.initStaticData();
        return this.name;
    }

    public String getVersion() {
        this.initStaticData();
        return this.version;
    }

    public String getPatchLevel() {
        this.initStaticData();
        return this.patchLevel;
    }

    public String getArch() {
        this.initStaticData();
        return this.arch;
    }

    public int getAvailableProcessors() {
        this.checkJmxApp();
        if (this.jmxApp == null) {
            return -1;
        }
        try {
            return this.osMXBean.getAvailableProcessors();
        }
        catch (UndeclaredThrowableException ex) {
            if (ex.getCause() instanceof ConnectException) {
                this.jmxApp = null;
                return this.getAvailableProcessors();
            }
            throw ex;
        }
    }

    public String getHostName() {
        return this.remoteHost.getHostName();
    }

    public double getSystemLoadAverage() {
        if (this.loadAverageAvailable) {
            this.checkJmxApp();
            if (this.jmxApp == null) {
                return -1.0;
            }
            try {
                return this.osMXBean.getSystemLoadAverage();
            }
            catch (UndeclaredThrowableException ex) {
                if (ex.getCause() instanceof ConnectException) {
                    this.jmxApp = null;
                    return this.getSystemLoadAverage();
                }
                throw ex;
            }
        }
        return -1.0;
    }

    public long getTotalPhysicalMemorySize() {
        this.checkJmxApp();
        if (this.jmxApp == null) {
            return -1L;
        }
        try {
            return this.getAttribute(this.totalPhysicalMemorySizeAttr);
        }
        catch (IOException ex) {
            this.jmxApp = null;
            return this.getTotalPhysicalMemorySize();
        }
    }

    public long getFreePhysicalMemorySize() {
        this.checkJmxApp();
        if (this.jmxApp == null) {
            return -1L;
        }
        try {
            return this.getAttribute(FreePhysicalMemorySizeAttr);
        }
        catch (IOException ex) {
            this.jmxApp = null;
            return this.getTotalPhysicalMemorySize();
        }
    }

    public long getTotalSwapSpaceSize() {
        this.checkJmxApp();
        if (this.jmxApp == null) {
            return -1L;
        }
        try {
            return this.getAttribute(TotalSwapSpaceSizeAttr);
        }
        catch (IOException ex) {
            this.jmxApp = null;
            return this.getTotalPhysicalMemorySize();
        }
    }

    public long getFreeSwapSpaceSize() {
        this.checkJmxApp();
        if (this.jmxApp == null) {
            return -1L;
        }
        try {
            return this.getAttribute(FreeSwapSpaceSizeAttr);
        }
        catch (IOException ex) {
            this.jmxApp = null;
            return this.getTotalPhysicalMemorySize();
        }
    }

    public String getHostAddress() {
        return this.remoteHost.getInetAddress().getHostAddress();
    }

    private synchronized void initStaticData() {
        if (this.staticDataInitialized) {
            return;
        }
        this.checkJmxApp();
        if (this.jmxApp == null) {
            return;
        }
        Properties sysProp = JvmFactory.getJVMFor((Application)this.jmxApp).getSystemProperties();
        this.name = this.osMXBean.getName();
        this.version = this.osMXBean.getVersion();
        this.patchLevel = sysProp.getProperty("sun.os.patch.level", "");
        this.arch = this.osMXBean.getArch();
        String bits = sysProp.getProperty("sun.arch.data.model");
        if (bits != null) {
            this.arch = this.arch + " " + bits + "bit";
        }
        this.staticDataInitialized = true;
    }

    private Application getJMXApplication() {
        Set apps = this.remoteHost.getRepository().getDataSources(Application.class);
        for (Application app : apps) {
            block9: {
                JmxModel jmx;
                if (app.getState() != 1 || (jmx = JmxModelFactory.getJmxModelFor((Application)app)) == null || !jmx.getConnectionState().equals((Object)JmxModel.ConnectionState.CONNECTED)) continue;
                JvmMXBeans mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmx);
                this.connection = jmx.getMBeanServerConnection();
                if (mxbeans == null || this.connection == null) continue;
                this.osMXBean = mxbeans.getOperatingSystemMXBean();
                this.loadAverageAvailable = false;
                try {
                    this.loadAverageAvailable = this.osMXBean.getSystemLoadAverage() >= 0.0;
                }
                catch (UndeclaredThrowableException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof AttributeNotFoundException) break block9;
                    throw ex;
                }
            }
            try {
                this.connection.getAttribute(osMXBeanName, TotalPhysicalMemorySizeAttr);
                this.totalPhysicalMemorySizeAttr = TotalPhysicalMemorySizeAttr;
            }
            catch (AttributeNotFoundException ex) {
                this.totalPhysicalMemorySizeAttr = TotalPhysicalMemorySizeAttr1;
            }
            catch (InstanceNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (ReflectionException ex) {
                throw new RuntimeException(ex);
            }
            catch (MBeanException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return app;
        }
        return null;
    }

    private synchronized void checkJmxApp() {
        if (this.jmxApp == null || this.jmxApp.getState() != 1) {
            this.jmxApp = this.getJMXApplication();
        }
    }

    private long getAttribute(String name) throws IOException {
        Object val = null;
        try {
            val = this.connection.getAttribute(osMXBeanName, name);
        }
        catch (AttributeNotFoundException ex) {
            return -1L;
        }
        catch (InstanceNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanException ex) {
            throw new RuntimeException(ex);
        }
        catch (ReflectionException ex) {
            throw new RuntimeException(ex);
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return -1L;
    }

    private static ObjectName getOperatingSystemMXBeanName() {
        try {
            return new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

