/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BaseInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener MY_PROPERTY_CHANGE_LISTENER = new MyPropertyChangeHandler();
    private static final Border HANDY_EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String FRAME_BORDER = "InternalFrame.border";
    private static String FRAME_PALETTE_BORDER = "InternalFrame.paletteBorder";
    private static String PALETTE_FRAME = "palette";

    public BaseInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BaseInternalFrameUI((JInternalFrame)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Object paletteProp = c.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        this.stripContentBorder();
    }

    public void uninstallUI(JComponent c) {
        JComponent contentPane;
        Container cp = this.frame.getContentPane();
        if (cp instanceof JComponent && (contentPane = (JComponent)cp).getBorder() == HANDY_EMPTY_BORDER) {
            contentPane.setBorder(null);
        }
        super.uninstallUI(c);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(MY_PROPERTY_CHANGE_LISTENER);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(MY_PROPERTY_CHANGE_LISTENER);
        super.uninstallListeners();
    }

    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    public void stripContentBorder() {
        JComponent contentPane;
        Border contentBorder;
        Container cp = this.frame.getContentPane();
        if (cp instanceof JComponent && ((contentBorder = (contentPane = (JComponent)cp).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentPane.setBorder(HANDY_EMPTY_BORDER);
        }
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        return new BaseInternalFrameTitlePane(w);
    }

    public BaseInternalFrameTitlePane getTitlePane() {
        return (BaseInternalFrameTitlePane)this.titlePane;
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            this.frame.setBorder(UIManager.getBorder(FRAME_PALETTE_BORDER));
        } else {
            this.frame.setBorder(UIManager.getBorder(FRAME_BORDER));
        }
        this.getTitlePane().setPalette(isPalette);
    }

    private static class MyPropertyChangeHandler
    implements PropertyChangeListener {
        private MyPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JInternalFrame jif = (JInternalFrame)e.getSource();
            if (!(jif.getUI() instanceof BaseInternalFrameUI)) {
                return;
            }
            BaseInternalFrameUI ui = (BaseInternalFrameUI)jif.getUI();
            String name = e.getPropertyName();
            if (name.equals(FRAME_TYPE)) {
                if (e.getNewValue() instanceof String) {
                    if (PALETTE_FRAME.equals(e.getNewValue())) {
                        LookAndFeel.installBorder(ui.frame, FRAME_PALETTE_BORDER);
                        ui.setPalette(true);
                    } else {
                        LookAndFeel.installBorder(ui.frame, FRAME_BORDER);
                        ui.setPalette(false);
                    }
                }
            } else if (name.equals(IS_PALETTE)) {
                if (e.getNewValue() != null) {
                    ui.setPalette((Boolean)e.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder();
            }
        }
    }
}

